// SPDX-License-Identifier: GPL-2.0-only
/*
 * Copyright (C) 2013-2014 Red Hat
 * Author: Rob Clark <robdclark@gmail.com>
 *
 * Copyright (c) 2014,2017 The Linux Foundation. All rights reserved.
 */

#include "adreno_gpu.h"
#include "a6xx_gpu.h"
#include "a6xx.xml.h"
#include "a6xx_gmu.xml.h"

static const struct adreno_reglist a612_hwcg[] = {
	{REG_A6XX_RBBM_CLOCK_CNTL_SP0, 0x22222222},
	{REG_A6XX_RBBM_CLOCK_CNTL2_SP0, 0x02222220},
	{REG_A6XX_RBBM_CLOCK_DELAY_SP0, 0x00000081},
	{REG_A6XX_RBBM_CLOCK_HYST_SP0, 0x0000f3cf},
	{REG_A6XX_RBBM_CLOCK_CNTL_TP0, 0x22222222},
	{REG_A6XX_RBBM_CLOCK_CNTL2_TP0, 0x22222222},
	{REG_A6XX_RBBM_CLOCK_CNTL3_TP0, 0x22222222},
	{REG_A6XX_RBBM_CLOCK_CNTL4_TP0, 0x00022222},
	{REG_A6XX_RBBM_CLOCK_DELAY_TP0, 0x11111111},
	{REG_A6XX_RBBM_CLOCK_DELAY2_TP0, 0x11111111},
	{REG_A6XX_RBBM_CLOCK_DELAY3_TP0, 0x11111111},
	{REG_A6XX_RBBM_CLOCK_DELAY4_TP0, 0x00011111},
	{REG_A6XX_RBBM_CLOCK_HYST_TP0, 0x77777777},
	{REG_A6XX_RBBM_CLOCK_HYST2_TP0, 0x77777777},
	{REG_A6XX_RBBM_CLOCK_HYST3_TP0, 0x77777777},
	{REG_A6XX_RBBM_CLOCK_HYST4_TP0, 0x00077777},
	{REG_A6XX_RBBM_CLOCK_CNTL_RB0, 0x22222222},
	{REG_A6XX_RBBM_CLOCK_CNTL2_RB0, 0x01202222},
	{REG_A6XX_RBBM_CLOCK_CNTL_CCU0, 0x00002220},
	{REG_A6XX_RBBM_CLOCK_HYST_RB_CCU0, 0x00040f00},
	{REG_A6XX_RBBM_CLOCK_CNTL_RAC, 0x05522022},
	{REG_A6XX_RBBM_CLOCK_CNTL2_RAC, 0x00005555},
	{REG_A6XX_RBBM_CLOCK_DELAY_RAC, 0x00000011},
	{REG_A6XX_RBBM_CLOCK_HYST_RAC, 0x00445044},
	{REG_A6XX_RBBM_CLOCK_CNTL_TSE_RAS_RBBM, 0x04222222},
	{REG_A6XX_RBBM_CLOCK_MODE_VFD, 0x00002222},
	{REG_A6XX_RBBM_CLOCK_MODE_GPC, 0x02222222},
	{REG_A6XX_RBBM_CLOCK_DELAY_HLSQ_2, 0x00000002},
	{REG_A6XX_RBBM_CLOCK_MODE_HLSQ, 0x00002222},
	{REG_A6XX_RBBM_CLOCK_DELAY_TSE_RAS_RBBM, 0x00004000},
	{REG_A6XX_RBBM_CLOCK_DELAY_VFD, 0x00002222},
	{REG_A6XX_RBBM_CLOCK_DELAY_GPC, 0x00000200},
	{REG_A6XX_RBBM_CLOCK_DELAY_HLSQ, 0x00000000},
	{REG_A6XX_RBBM_CLOCK_HYST_TSE_RAS_RBBM, 0x00000000},
	{REG_A6XX_RBBM_CLOCK_HYST_VFD, 0x00000000},
	{REG_A6XX_RBBM_CLOCK_HYST_GPC, 0x04104004},
	{REG_A6XX_RBBM_CLOCK_HYST_HLSQ, 0x00000000},
	{REG_A6XX_RBBM_CLOCK_CNTL_UCHE, 0x22222222},
	{REG_A6XX_RBBM_CLOCK_HYST_UCHE, 0x00000004},
	{REG_A6XX_RBBM_CLOCK_DELAY_UCHE, 0x00000002},
	{REG_A6XX_RBBM_ISDB_CNT, 0x00000182},
	{REG_A6XX_RBBM_RAC_THRESHOLD_CNT, 0x00000000},
	{REG_A6XX_RBBM_SP_HYST_CNT, 0x00000000},
	{REG_A6XX_RBBM_CLOCK_CNTL_GMU_GX, 0x00000222},
	{REG_A6XX_RBBM_CLOCK_DELAY_GMU_GX, 0x00000111},
	{REG_A6XX_RBBM_CLOCK_HYST_GMU_GX, 0x00000555},
	{},
};

/* For a615 family (a615, a616, a618 and a619) */
static const struct adreno_reglist a615_hwcg[] = {
	{REG_A6XX_RBBM_CLOCK_CNTL_SP0,  0x02222222},
	{REG_A6XX_RBBM_CLOCK_CNTL2_SP0, 0x02222220},
	{REG_A6XX_RBBM_CLOCK_DELAY_SP0, 0x00000080},
	{REG_A6XX_RBBM_CLOCK_HYST_SP0,  0x0000F3CF},
	{REG_A6XX_RBBM_CLOCK_CNTL_TP0,  0x02222222},
	{REG_A6XX_RBBM_CLOCK_CNTL_TP1,  0x02222222},
	{REG_A6XX_RBBM_CLOCK_CNTL2_TP0, 0x22222222},
	{REG_A6XX_RBBM_CLOCK_CNTL2_TP1, 0x22222222},
	{REG_A6XX_RBBM_CLOCK_CNTL3_TP0, 0x22222222},
	{REG_A6XX_RBBM_CLOCK_CNTL3_TP1, 0x22222222},
	{REG_A6XX_RBBM_CLOCK_CNTL4_TP0, 0x00022222},
	{REG_A6XX_RBBM_CLOCK_CNTL4_TP1, 0x00022222},
	{REG_A6XX_RBBM_CLOCK_HYST_TP0,  0x77777777},
	{REG_A6XX_RBBM_CLOCK_HYST_TP1,  0x77777777},
	{REG_A6XX_RBBM_CLOCK_HYST2_TP0, 0x77777777},
	{REG_A6XX_RBBM_CLOCK_HYST2_TP1, 0x77777777},
	{REG_A6XX_RBBM_CLOCK_HYST3_TP0, 0x77777777},
	{REG_A6XX_RBBM_CLOCK_HYST3_TP1, 0x77777777},
	{REG_A6XX_RBBM_CLOCK_HYST4_TP0, 0x00077777},
	{REG_A6XX_RBBM_CLOCK_HYST4_TP1, 0x00077777},
	{REG_A6XX_RBBM_CLOCK_DELAY_TP0, 0x11111111},
	{REG_A6XX_RBBM_CLOCK_DELAY_TP1, 0x11111111},
	{REG_A6XX_RBBM_CLOCK_DELAY2_TP0, 0x11111111},
	{REG_A6XX_RBBM_CLOCK_DELAY2_TP1, 0x11111111},
	{REG_A6XX_RBBM_CLOCK_DELAY3_TP0, 0x11111111},
	{REG_A6XX_RBBM_CLOCK_DELAY3_TP1, 0x11111111},
	{REG_A6XX_RBBM_CLOCK_DELAY4_TP0, 0x00011111},
	{REG_A6XX_RBBM_CLOCK_DELAY4_TP1, 0x00011111},
	{REG_A6XX_RBBM_CLOCK_CNTL_UCHE,  0x22222222},
	{REG_A6XX_RBBM_CLOCK_CNTL2_UCHE, 0x22222222},
	{REG_A6XX_RBBM_CLOCK_CNTL3_UCHE, 0x22222222},
	{REG_A6XX_RBBM_CLOCK_CNTL4_UCHE, 0x00222222},
	{REG_A6XX_RBBM_CLOCK_HYST_UCHE,  0x00000004},
	{REG_A6XX_RBBM_CLOCK_DELAY_UCHE, 0x00000002},
	{REG_A6XX_RBBM_CLOCK_CNTL_RB0, 0x22222222},
	{REG_A6XX_RBBM_CLOCK_CNTL2_RB0, 0x00002222},
	{REG_A6XX_RBBM_CLOCK_CNTL_CCU0, 0x00002020},
	{REG_A6XX_RBBM_CLOCK_CNTL_CCU1, 0x00002220},
	{REG_A6XX_RBBM_CLOCK_CNTL_CCU2, 0x00002220},
	{REG_A6XX_RBBM_CLOCK_CNTL_CCU3, 0x00002220},
	{REG_A6XX_RBBM_CLOCK_HYST_RB_CCU0, 0x00040F00},
	{REG_A6XX_RBBM_CLOCK_HYST_RB_CCU1, 0x00040F00},
	{REG_A6XX_RBBM_CLOCK_HYST_RB_CCU2, 0x00040F00},
	{REG_A6XX_RBBM_CLOCK_HYST_RB_CCU3, 0x00040F00},
	{REG_A6XX_RBBM_CLOCK_CNTL_RAC, 0x05022022},
	{REG_A6XX_RBBM_CLOCK_CNTL2_RAC, 0x00005555},
	{REG_A6XX_RBBM_CLOCK_DELAY_RAC, 0x00000011},
	{REG_A6XX_RBBM_CLOCK_HYST_RAC, 0x00445044},
	{REG_A6XX_RBBM_CLOCK_CNTL_TSE_RAS_RBBM, 0x04222222},
	{REG_A6XX_RBBM_CLOCK_MODE_GPC, 0x00222222},
	{REG_A6XX_RBBM_CLOCK_MODE_VFD, 0x00002222},
	{REG_A6XX_RBBM_CLOCK_HYST_TSE_RAS_RBBM, 0x00000000},
	{REG_A6XX_RBBM_CLOCK_HYST_GPC, 0x04104004},
	{REG_A6XX_RBBM_CLOCK_HYST_VFD, 0x00000000},
	{REG_A6XX_RBBM_CLOCK_DELAY_HLSQ, 0x00000000},
	{REG_A6XX_RBBM_CLOCK_DELAY_TSE_RAS_RBBM, 0x00004000},
	{REG_A6XX_RBBM_CLOCK_DELAY_GPC, 0x00000200},
	{REG_A6XX_RBBM_CLOCK_DELAY_VFD, 0x00002222},
	{REG_A6XX_RBBM_CLOCK_DELAY_HLSQ_2, 0x00000002},
	{REG_A6XX_RBBM_CLOCK_MODE_HLSQ, 0x00002222},
	{REG_A6XX_RBBM_CLOCK_CNTL_GMU_GX, 0x00000222},
	{REG_A6XX_RBBM_CLOCK_DELAY_GMU_GX, 0x00000111},
	{REG_A6XX_RBBM_CLOCK_HYST_GMU_GX, 0x00000555},
	{},
};

static const struct adreno_reglist a620_hwcg[] = {
	{REG_A6XX_RBBM_CLOCK_CNTL_SP0, 0x02222222},
	{REG_A6XX_RBBM_CLOCK_CNTL2_SP0, 0x02222220},
	{REG_A6XX_RBBM_CLOCK_DELAY_SP0, 0x00000080},
	{REG_A6XX_RBBM_CLOCK_HYST_SP0, 0x0000f3cf},
	{REG_A6XX_RBBM_CLOCK_CNTL_TP0, 0x02222222},
	{REG_A6XX_RBBM_CLOCK_CNTL2_TP0, 0x22222222},
	{REG_A6XX_RBBM_CLOCK_CNTL3_TP0, 0x22222222},
	{REG_A6XX_RBBM_CLOCK_CNTL4_TP0, 0x00022222},
	{REG_A6XX_RBBM_CLOCK_DELAY_TP0, 0x11111111},
	{REG_A6XX_RBBM_CLOCK_DELAY2_TP0, 0x11111111},
	{REG_A6XX_RBBM_CLOCK_DELAY3_TP0, 0x11111111},
	{REG_A6XX_RBBM_CLOCK_DELAY4_TP0, 0x00011111},
	{REG_A6XX_RBBM_CLOCK_HYST_TP0, 0x77777777},
	{REG_A6XX_RBBM_CLOCK_HYST2_TP0, 0x77777777},
	{REG_A6XX_RBBM_CLOCK_HYST3_TP0, 0x77777777},
	{REG_A6XX_RBBM_CLOCK_HYST4_TP0, 0x00077777},
	{REG_A6XX_RBBM_CLOCK_CNTL_RB0, 0x22222222},
	{REG_A6XX_RBBM_CLOCK_CNTL2_RB0, 0x01002222},
	{REG_A6XX_RBBM_CLOCK_CNTL_CCU0, 0x00002220},
	{REG_A6XX_RBBM_CLOCK_HYST_RB_CCU0, 0x00040f00},
	{REG_A6XX_RBBM_CLOCK_CNTL_RAC, 0x25222022},
	{REG_A6XX_RBBM_CLOCK_CNTL2_RAC, 0x00005555},
	{REG_A6XX_RBBM_CLOCK_DELAY_RAC, 0x00000011},
	{REG_A6XX_RBBM_CLOCK_HYST_RAC, 0x00445044},
	{REG_A6XX_RBBM_CLOCK_CNTL_TSE_RAS_RBBM, 0x04222222},
	{REG_A6XX_RBBM_CLOCK_MODE_VFD, 0x00002222},
	{REG_A6XX_RBBM_CLOCK_MODE_GPC, 0x00222222},
	{REG_A6XX_RBBM_CLOCK_DELAY_HLSQ_2, 0x00000002},
	{REG_A6XX_RBBM_CLOCK_MODE_HLSQ, 0x00002222},
	{REG_A6XX_RBBM_CLOCK_DELAY_TSE_RAS_RBBM, 0x00004000},
	{REG_A6XX_RBBM_CLOCK_DELAY_VFD, 0x00002222},
	{REG_A6XX_RBBM_CLOCK_DELAY_GPC, 0x00000200},
	{REG_A6XX_RBBM_CLOCK_DELAY_HLSQ, 0x00000000},
	{REG_A6XX_RBBM_CLOCK_HYST_TSE_RAS_RBBM, 0x00000000},
	{REG_A6XX_RBBM_CLOCK_HYST_VFD, 0x00000000},
	{REG_A6XX_RBBM_CLOCK_HYST_GPC, 0x04104004},
	{REG_A6XX_RBBM_CLOCK_HYST_HLSQ, 0x00000000},
	{REG_A6XX_RBBM_CLOCK_CNTL_TEX_FCHE, 0x00000222},
	{REG_A6XX_RBBM_CLOCK_DELAY_TEX_FCHE, 0x00000111},
	{REG_A6XX_RBBM_CLOCK_HYST_TEX_FCHE, 0x00000777},
	{REG_A6XX_RBBM_CLOCK_CNTL_UCHE, 0x22222222},
	{REG_A6XX_RBBM_CLOCK_HYST_UCHE, 0x00000004},
	{REG_A6XX_RBBM_CLOCK_DELAY_UCHE, 0x00000002},
	{REG_A6XX_RBBM_ISDB_CNT, 0x00000182},
	{REG_A6XX_RBBM_RAC_THRESHOLD_CNT, 0x00000000},
	{REG_A6XX_RBBM_SP_HYST_CNT, 0x00000000},
	{REG_A6XX_RBBM_CLOCK_CNTL_GMU_GX, 0x00000222},
	{REG_A6XX_RBBM_CLOCK_DELAY_GMU_GX, 0x00000111},
	{REG_A6XX_RBBM_CLOCK_HYST_GMU_GX, 0x00000555},
	{},
};

static const struct adreno_reglist a630_hwcg[] = {
	{REG_A6XX_RBBM_CLOCK_CNTL_SP0, 0x22222222},
	{REG_A6XX_RBBM_CLOCK_CNTL_SP1, 0x22222222},
	{REG_A6XX_RBBM_CLOCK_CNTL_SP2, 0x22222222},
	{REG_A6XX_RBBM_CLOCK_CNTL_SP3, 0x22222222},
	{REG_A6XX_RBBM_CLOCK_CNTL2_SP0, 0x02022220},
	{REG_A6XX_RBBM_CLOCK_CNTL2_SP1, 0x02022220},
	{REG_A6XX_RBBM_CLOCK_CNTL2_SP2, 0x02022220},
	{REG_A6XX_RBBM_CLOCK_CNTL2_SP3, 0x02022220},
	{REG_A6XX_RBBM_CLOCK_DELAY_SP0, 0x00000080},
	{REG_A6XX_RBBM_CLOCK_DELAY_SP1, 0x00000080},
	{REG_A6XX_RBBM_CLOCK_DELAY_SP2, 0x00000080},
	{REG_A6XX_RBBM_CLOCK_DELAY_SP3, 0x00000080},
	{REG_A6XX_RBBM_CLOCK_HYST_SP0, 0x0000f3cf},
	{REG_A6XX_RBBM_CLOCK_HYST_SP1, 0x0000f3cf},
	{REG_A6XX_RBBM_CLOCK_HYST_SP2, 0x0000f3cf},
	{REG_A6XX_RBBM_CLOCK_HYST_SP3, 0x0000f3cf},
	{REG_A6XX_RBBM_CLOCK_CNTL_TP0, 0x02222222},
	{REG_A6XX_RBBM_CLOCK_CNTL_TP1, 0x02222222},
	{REG_A6XX_RBBM_CLOCK_CNTL_TP2, 0x02222222},
	{REG_A6XX_RBBM_CLOCK_CNTL_TP3, 0x02222222},
	{REG_A6XX_RBBM_CLOCK_CNTL2_TP0, 0x22222222},
	{REG_A6XX_RBBM_CLOCK_CNTL2_TP1, 0x22222222},
	{REG_A6XX_RBBM_CLOCK_CNTL2_TP2, 0x22222222},
	{REG_A6XX_RBBM_CLOCK_CNTL2_TP3, 0x22222222},
	{REG_A6XX_RBBM_CLOCK_CNTL3_TP0, 0x22222222},
	{REG_A6XX_RBBM_CLOCK_CNTL3_TP1, 0x22222222},
	{REG_A6XX_RBBM_CLOCK_CNTL3_TP2, 0x22222222},
	{REG_A6XX_RBBM_CLOCK_CNTL3_TP3, 0x22222222},
	{REG_A6XX_RBBM_CLOCK_CNTL4_TP0, 0x00022222},
	{REG_A6XX_RBBM_CLOCK_CNTL4_TP1, 0x00022222},
	{REG_A6XX_RBBM_CLOCK_CNTL4_TP2, 0x00022222},
	{REG_A6XX_RBBM_CLOCK_CNTL4_TP3, 0x00022222},
	{REG_A6XX_RBBM_CLOCK_HYST_TP0, 0x77777777},
	{REG_A6XX_RBBM_CLOCK_HYST_TP1, 0x77777777},
	{REG_A6XX_RBBM_CLOCK_HYST_TP2, 0x77777777},
	{REG_A6XX_RBBM_CLOCK_HYST_TP3, 0x77777777},
	{REG_A6XX_RBBM_CLOCK_HYST2_TP0, 0x77777777},
	{REG_A6XX_RBBM_CLOCK_HYST2_TP1, 0x77777777},
	{REG_A6XX_RBBM_CLOCK_HYST2_TP2, 0x77777777},
	{REG_A6XX_RBBM_CLOCK_HYST2_TP3, 0x77777777},
	{REG_A6XX_RBBM_CLOCK_HYST3_TP0, 0x77777777},
	{REG_A6XX_RBBM_CLOCK_HYST3_TP1, 0x77777777},
	{REG_A6XX_RBBM_CLOCK_HYST3_TP2, 0x77777777},
	{REG_A6XX_RBBM_CLOCK_HYST3_TP3, 0x77777777},
	{REG_A6XX_RBBM_CLOCK_HYST4_TP0, 0x00077777},
	{REG_A6XX_RBBM_CLOCK_HYST4_TP1, 0x00077777},
	{REG_A6XX_RBBM_CLOCK_HYST4_TP2, 0x00077777},
	{REG_A6XX_RBBM_CLOCK_HYST4_TP3, 0x00077777},
	{REG_A6XX_RBBM_CLOCK_DELAY_TP0, 0x11111111},
	{REG_A6XX_RBBM_CLOCK_DELAY_TP1, 0x11111111},
	{REG_A6XX_RBBM_CLOCK_DELAY_TP2, 0x11111111},
	{REG_A6XX_RBBM_CLOCK_DELAY_TP3, 0x11111111},
	{REG_A6XX_RBBM_CLOCK_DELAY2_TP0, 0x11111111},
	{REG_A6XX_RBBM_CLOCK_DELAY2_TP1, 0x11111111},
	{REG_A6XX_RBBM_CLOCK_DELAY2_TP2, 0x11111111},
	{REG_A6XX_RBBM_CLOCK_DELAY2_TP3, 0x11111111},
	{REG_A6XX_RBBM_CLOCK_DELAY3_TP0, 0x11111111},
	{REG_A6XX_RBBM_CLOCK_DELAY3_TP1, 0x11111111},
	{REG_A6XX_RBBM_CLOCK_DELAY3_TP2, 0x11111111},
	{REG_A6XX_RBBM_CLOCK_DELAY3_TP3, 0x11111111},
	{REG_A6XX_RBBM_CLOCK_DELAY4_TP0, 0x00011111},
	{REG_A6XX_RBBM_CLOCK_DELAY4_TP1, 0x00011111},
	{REG_A6XX_RBBM_CLOCK_DELAY4_TP2, 0x00011111},
	{REG_A6XX_RBBM_CLOCK_DELAY4_TP3, 0x00011111},
	{REG_A6XX_RBBM_CLOCK_CNTL_UCHE, 0x22222222},
	{REG_A6XX_RBBM_CLOCK_CNTL2_UCHE, 0x22222222},
	{REG_A6XX_RBBM_CLOCK_CNTL3_UCHE, 0x22222222},
	{REG_A6XX_RBBM_CLOCK_CNTL4_UCHE, 0x00222222},
	{REG_A6XX_RBBM_CLOCK_HYST_UCHE, 0x00000004},
	{REG_A6XX_RBBM_CLOCK_DELAY_UCHE, 0x00000002},
	{REG_A6XX_RBBM_CLOCK_CNTL_RB0, 0x22222222},
	{REG_A6XX_RBBM_CLOCK_CNTL_RB1, 0x22222222},
	{REG_A6XX_RBBM_CLOCK_CNTL_RB2, 0x22222222},
	{REG_A6XX_RBBM_CLOCK_CNTL_RB3, 0x22222222},
	{REG_A6XX_RBBM_CLOCK_CNTL2_RB0, 0x00002222},
	{REG_A6XX_RBBM_CLOCK_CNTL2_RB1, 0x00002222},
	{REG_A6XX_RBBM_CLOCK_CNTL2_RB2, 0x00002222},
	{REG_A6XX_RBBM_CLOCK_CNTL2_RB3, 0x00002222},
	{REG_A6XX_RBBM_CLOCK_CNTL_CCU0, 0x00002220},
	{REG_A6XX_RBBM_CLOCK_CNTL_CCU1, 0x00002220},
	{REG_A6XX_RBBM_CLOCK_CNTL_CCU2, 0x00002220},
	{REG_A6XX_RBBM_CLOCK_CNTL_CCU3, 0x00002220},
	{REG_A6XX_RBBM_CLOCK_HYST_RB_CCU0, 0x00040f00},
	{REG_A6XX_RBBM_CLOCK_HYST_RB_CCU1, 0x00040f00},
	{REG_A6XX_RBBM_CLOCK_HYST_RB_CCU2, 0x00040f00},
	{REG_A6XX_RBBM_CLOCK_HYST_RB_CCU3, 0x00040f00},
	{REG_A6XX_RBBM_CLOCK_CNTL_RAC, 0x05022022},
	{REG_A6XX_RBBM_CLOCK_CNTL2_RAC, 0x00005555},
	{REG_A6XX_RBBM_CLOCK_DELAY_RAC, 0x00000011},
	{REG_A6XX_RBBM_CLOCK_HYST_RAC, 0x00445044},
	{REG_A6XX_RBBM_CLOCK_CNTL_TSE_RAS_RBBM, 0x04222222},
	{REG_A6XX_RBBM_CLOCK_MODE_GPC, 0x00222222},
	{REG_A6XX_RBBM_CLOCK_MODE_VFD, 0x00002222},
	{REG_A6XX_RBBM_CLOCK_HYST_TSE_RAS_RBBM, 0x00000000},
	{REG_A6XX_RBBM_CLOCK_HYST_GPC, 0x04104004},
	{REG_A6XX_RBBM_CLOCK_HYST_VFD, 0x00000000},
	{REG_A6XX_RBBM_CLOCK_DELAY_HLSQ, 0x00000000},
	{REG_A6XX_RBBM_CLOCK_DELAY_TSE_RAS_RBBM, 0x00004000},
	{REG_A6XX_RBBM_CLOCK_DELAY_GPC, 0x00000200},
	{REG_A6XX_RBBM_CLOCK_DELAY_VFD, 0x00002222},
	{REG_A6XX_RBBM_CLOCK_DELAY_HLSQ_2, 0x00000002},
	{REG_A6XX_RBBM_CLOCK_MODE_HLSQ, 0x00002222},
	{REG_A6XX_RBBM_CLOCK_CNTL_GMU_GX, 0x00000222},
	{REG_A6XX_RBBM_CLOCK_DELAY_GMU_GX, 0x00000111},
	{REG_A6XX_RBBM_CLOCK_HYST_GMU_GX, 0x00000555},
	{},
};

static const struct adreno_reglist a640_hwcg[] = {
	{REG_A6XX_RBBM_CLOCK_CNTL_SP0, 0x02222222},
	{REG_A6XX_RBBM_CLOCK_CNTL2_SP0, 0x02222220},
	{REG_A6XX_RBBM_CLOCK_DELAY_SP0, 0x00000080},
	{REG_A6XX_RBBM_CLOCK_HYST_SP0, 0x0000F3CF},
	{REG_A6XX_RBBM_CLOCK_CNTL_TP0, 0x02222222},
	{REG_A6XX_RBBM_CLOCK_CNTL2_TP0, 0x22222222},
	{REG_A6XX_RBBM_CLOCK_CNTL3_TP0, 0x22222222},
	{REG_A6XX_RBBM_CLOCK_CNTL4_TP0, 0x00022222},
	{REG_A6XX_RBBM_CLOCK_DELAY_TP0, 0x11111111},
	{REG_A6XX_RBBM_CLOCK_DELAY2_TP0, 0x11111111},
	{REG_A6XX_RBBM_CLOCK_DELAY3_TP0, 0x11111111},
	{REG_A6XX_RBBM_CLOCK_DELAY4_TP0, 0x00011111},
	{REG_A6XX_RBBM_CLOCK_HYST_TP0, 0x77777777},
	{REG_A6XX_RBBM_CLOCK_HYST2_TP0, 0x77777777},
	{REG_A6XX_RBBM_CLOCK_HYST3_TP0, 0x77777777},
	{REG_A6XX_RBBM_CLOCK_HYST4_TP0, 0x00077777},
	{REG_A6XX_RBBM_CLOCK_CNTL_RB0, 0x22222222},
	{REG_A6XX_RBBM_CLOCK_CNTL2_RB0, 0x01002222},
	{REG_A6XX_RBBM_CLOCK_CNTL_CCU0, 0x00002220},
	{REG_A6XX_RBBM_CLOCK_HYST_RB_CCU0, 0x00040F00},
	{REG_A6XX_RBBM_CLOCK_CNTL_RAC, 0x05222022},
	{REG_A6XX_RBBM_CLOCK_CNTL2_RAC, 0x00005555},
	{REG_A6XX_RBBM_CLOCK_DELAY_RAC, 0x00000011},
	{REG_A6XX_RBBM_CLOCK_HYST_RAC, 0x00445044},
	{REG_A6XX_RBBM_CLOCK_CNTL_TSE_RAS_RBBM, 0x04222222},
	{REG_A6XX_RBBM_CLOCK_MODE_VFD, 0x00002222},
	{REG_A6XX_RBBM_CLOCK_MODE_GPC, 0x00222222},
	{REG_A6XX_RBBM_CLOCK_DELAY_HLSQ_2, 0x00000002},
	{REG_A6XX_RBBM_CLOCK_MODE_HLSQ, 0x00002222},
	{REG_A6XX_RBBM_CLOCK_DELAY_TSE_RAS_RBBM, 0x00004000},
	{REG_A6XX_RBBM_CLOCK_DELAY_VFD, 0x00002222},
	{REG_A6XX_RBBM_CLOCK_DELAY_GPC, 0x00000200},
	{REG_A6XX_RBBM_CLOCK_DELAY_HLSQ, 0x00000000},
	{REG_A6XX_RBBM_CLOCK_HYST_TSE_RAS_RBBM, 0x00000000},
	{REG_A6XX_RBBM_CLOCK_HYST_VFD, 0x00000000},
	{REG_A6XX_RBBM_CLOCK_HYST_GPC, 0x04104004},
	{REG_A6XX_RBBM_CLOCK_HYST_HLSQ, 0x00000000},
	{REG_A6XX_RBBM_CLOCK_CNTL_TEX_FCHE, 0x00000222},
	{REG_A6XX_RBBM_CLOCK_DELAY_TEX_FCHE, 0x00000111},
	{REG_A6XX_RBBM_CLOCK_HYST_TEX_FCHE, 0x00000000},
	{REG_A6XX_RBBM_CLOCK_CNTL_UCHE, 0x22222222},
	{REG_A6XX_RBBM_CLOCK_HYST_UCHE, 0x00000004},
	{REG_A6XX_RBBM_CLOCK_DELAY_UCHE, 0x00000002},
	{REG_A6XX_RBBM_ISDB_CNT, 0x00000182},
	{REG_A6XX_RBBM_RAC_THRESHOLD_CNT, 0x00000000},
	{REG_A6XX_RBBM_SP_HYST_CNT, 0x00000000},
	{REG_A6XX_RBBM_CLOCK_CNTL_GMU_GX, 0x00000222},
	{REG_A6XX_RBBM_CLOCK_DELAY_GMU_GX, 0x00000111},
	{REG_A6XX_RBBM_CLOCK_HYST_GMU_GX, 0x00000555},
	{},
};

static const struct adreno_reglist a650_hwcg[] = {
	{REG_A6XX_RBBM_CLOCK_CNTL_SP0, 0x02222222},
	{REG_A6XX_RBBM_CLOCK_CNTL2_SP0, 0x02222220},
	{REG_A6XX_RBBM_CLOCK_DELAY_SP0, 0x00000080},
	{REG_A6XX_RBBM_CLOCK_HYST_SP0, 0x0000F3CF},
	{REG_A6XX_RBBM_CLOCK_CNTL_TP0, 0x02222222},
	{REG_A6XX_RBBM_CLOCK_CNTL2_TP0, 0x22222222},
	{REG_A6XX_RBBM_CLOCK_CNTL3_TP0, 0x22222222},
	{REG_A6XX_RBBM_CLOCK_CNTL4_TP0, 0x00022222},
	{REG_A6XX_RBBM_CLOCK_DELAY_TP0, 0x11111111},
	{REG_A6XX_RBBM_CLOCK_DELAY2_TP0, 0x11111111},
	{REG_A6XX_RBBM_CLOCK_DELAY3_TP0, 0x11111111},
	{REG_A6XX_RBBM_CLOCK_DELAY4_TP0, 0x00011111},
	{REG_A6XX_RBBM_CLOCK_HYST_TP0, 0x77777777},
	{REG_A6XX_RBBM_CLOCK_HYST2_TP0, 0x77777777},
	{REG_A6XX_RBBM_CLOCK_HYST3_TP0, 0x77777777},
	{REG_A6XX_RBBM_CLOCK_HYST4_TP0, 0x00077777},
	{REG_A6XX_RBBM_CLOCK_CNTL_RB0, 0x22222222},
	{REG_A6XX_RBBM_CLOCK_CNTL2_RB0, 0x01002222},
	{REG_A6XX_RBBM_CLOCK_CNTL_CCU0, 0x00002220},
	{REG_A6XX_RBBM_CLOCK_HYST_RB_CCU0, 0x00040F00},
	{REG_A6XX_RBBM_CLOCK_CNTL_RAC, 0x25222022},
	{REG_A6XX_RBBM_CLOCK_CNTL2_RAC, 0x00005555},
	{REG_A6XX_RBBM_CLOCK_DELAY_RAC, 0x00000011},
	{REG_A6XX_RBBM_CLOCK_HYST_RAC, 0x00445044},
	{REG_A6XX_RBBM_CLOCK_CNTL_TSE_RAS_RBBM, 0x04222222},
	{REG_A6XX_RBBM_CLOCK_MODE_VFD, 0x00002222},
	{REG_A6XX_RBBM_CLOCK_MODE_GPC, 0x00222222},
	{REG_A6XX_RBBM_CLOCK_DELAY_HLSQ_2, 0x00000002},
	{REG_A6XX_RBBM_CLOCK_MODE_HLSQ, 0x00002222},
	{REG_A6XX_RBBM_CLOCK_DELAY_TSE_RAS_RBBM, 0x00004000},
	{REG_A6XX_RBBM_CLOCK_DELAY_VFD, 0x00002222},
	{REG_A6XX_RBBM_CLOCK_DELAY_GPC, 0x00000200},
	{REG_A6XX_RBBM_CLOCK_DELAY_HLSQ, 0x00000000},
	{REG_A6XX_RBBM_CLOCK_HYST_TSE_RAS_RBBM, 0x00000000},
	{REG_A6XX_RBBM_CLOCK_HYST_VFD, 0x00000000},
	{REG_A6XX_RBBM_CLOCK_HYST_GPC, 0x04104004},
	{REG_A6XX_RBBM_CLOCK_HYST_HLSQ, 0x00000000},
	{REG_A6XX_RBBM_CLOCK_CNTL_TEX_FCHE, 0x00000222},
	{REG_A6XX_RBBM_CLOCK_DELAY_TEX_FCHE, 0x00000111},
	{REG_A6XX_RBBM_CLOCK_HYST_TEX_FCHE, 0x00000777},
	{REG_A6XX_RBBM_CLOCK_CNTL_UCHE, 0x22222222},
	{REG_A6XX_RBBM_CLOCK_HYST_UCHE, 0x00000004},
	{REG_A6XX_RBBM_CLOCK_DELAY_UCHE, 0x00000002},
	{REG_A6XX_RBBM_ISDB_CNT, 0x00000182},
	{REG_A6XX_RBBM_RAC_THRESHOLD_CNT, 0x00000000},
	{REG_A6XX_RBBM_SP_HYST_CNT, 0x00000000},
	{REG_A6XX_RBBM_CLOCK_CNTL_GMU_GX, 0x00000222},
	{REG_A6XX_RBBM_CLOCK_DELAY_GMU_GX, 0x00000111},
	{REG_A6XX_RBBM_CLOCK_HYST_GMU_GX, 0x00000555},
	{},
};

static const struct adreno_reglist a660_hwcg[] = {
	{REG_A6XX_RBBM_CLOCK_CNTL_SP0, 0x02222222},
	{REG_A6XX_RBBM_CLOCK_CNTL2_SP0, 0x02222220},
	{REG_A6XX_RBBM_CLOCK_DELAY_SP0, 0x00000080},
	{REG_A6XX_RBBM_CLOCK_HYST_SP0, 0x0000F3CF},
	{REG_A6XX_RBBM_CLOCK_CNTL_TP0, 0x22222222},
	{REG_A6XX_RBBM_CLOCK_CNTL2_TP0, 0x22222222},
	{REG_A6XX_RBBM_CLOCK_CNTL3_TP0, 0x22222222},
	{REG_A6XX_RBBM_CLOCK_CNTL4_TP0, 0x00022222},
	{REG_A6XX_RBBM_CLOCK_DELAY_TP0, 0x11111111},
	{REG_A6XX_RBBM_CLOCK_DELAY2_TP0, 0x11111111},
	{REG_A6XX_RBBM_CLOCK_DELAY3_TP0, 0x11111111},
	{REG_A6XX_RBBM_CLOCK_DELAY4_TP0, 0x00011111},
	{REG_A6XX_RBBM_CLOCK_HYST_TP0, 0x77777777},
	{REG_A6XX_RBBM_CLOCK_HYST2_TP0, 0x77777777},
	{REG_A6XX_RBBM_CLOCK_HYST3_TP0, 0x77777777},
	{REG_A6XX_RBBM_CLOCK_HYST4_TP0, 0x00077777},
	{REG_A6XX_RBBM_CLOCK_CNTL_RB0, 0x22222222},
	{REG_A6XX_RBBM_CLOCK_CNTL2_RB0, 0x01002222},
	{REG_A6XX_RBBM_CLOCK_CNTL_CCU0, 0x00002220},
	{REG_A6XX_RBBM_CLOCK_HYST_RB_CCU0, 0x00040F00},
	{REG_A6XX_RBBM_CLOCK_CNTL_RAC, 0x25222022},
	{REG_A6XX_RBBM_CLOCK_CNTL2_RAC, 0x00005555},
	{REG_A6XX_RBBM_CLOCK_DELAY_RAC, 0x00000011},
	{REG_A6XX_RBBM_CLOCK_HYST_RAC, 0x00445044},
	{REG_A6XX_RBBM_CLOCK_CNTL_TSE_RAS_RBBM, 0x04222222},
	{REG_A6XX_RBBM_CLOCK_MODE_VFD, 0x00002222},
	{REG_A6XX_RBBM_CLOCK_MODE_GPC, 0x00222222},
	{REG_A6XX_RBBM_CLOCK_DELAY_HLSQ_2, 0x00000002},
	{REG_A6XX_RBBM_CLOCK_MODE_HLSQ, 0x00002222},
	{REG_A6XX_RBBM_CLOCK_DELAY_TSE_RAS_RBBM, 0x00004000},
	{REG_A6XX_RBBM_CLOCK_DELAY_VFD, 0x00002222},
	{REG_A6XX_RBBM_CLOCK_DELAY_GPC, 0x00000200},
	{REG_A6XX_RBBM_CLOCK_DELAY_HLSQ, 0x00000000},
	{REG_A6XX_RBBM_CLOCK_HYST_TSE_RAS_RBBM, 0x00000000},
	{REG_A6XX_RBBM_CLOCK_HYST_VFD, 0x00000000},
	{REG_A6XX_RBBM_CLOCK_HYST_GPC, 0x04104004},
	{REG_A6XX_RBBM_CLOCK_HYST_HLSQ, 0x00000000},
	{REG_A6XX_RBBM_CLOCK_CNTL_TEX_FCHE, 0x00000222},
	{REG_A6XX_RBBM_CLOCK_DELAY_TEX_FCHE, 0x00000111},
	{REG_A6XX_RBBM_CLOCK_HYST_TEX_FCHE, 0x00000000},
	{REG_A6XX_RBBM_CLOCK_CNTL_UCHE, 0x22222222},
	{REG_A6XX_RBBM_CLOCK_HYST_UCHE, 0x00000004},
	{REG_A6XX_RBBM_CLOCK_DELAY_UCHE, 0x00000002},
	{REG_A6XX_RBBM_ISDB_CNT, 0x00000182},
	{REG_A6XX_RBBM_RAC_THRESHOLD_CNT, 0x00000000},
	{REG_A6XX_RBBM_SP_HYST_CNT, 0x00000000},
	{REG_A6XX_RBBM_CLOCK_CNTL_GMU_GX, 0x00000222},
	{REG_A6XX_RBBM_CLOCK_DELAY_GMU_GX, 0x00000111},
	{REG_A6XX_RBBM_CLOCK_HYST_GMU_GX, 0x00000555},
	{},
};

static const struct adreno_reglist a690_hwcg[] = {
	{REG_A6XX_RBBM_CLOCK_CNTL_SP0, 0x02222222},
	{REG_A6XX_RBBM_CLOCK_CNTL2_SP0, 0x02222220},
	{REG_A6XX_RBBM_CLOCK_DELAY_SP0, 0x00000080},
	{REG_A6XX_RBBM_CLOCK_HYST_SP0, 0x0000F3CF},
	{REG_A6XX_RBBM_CLOCK_CNTL_TP0, 0x22222222},
	{REG_A6XX_RBBM_CLOCK_CNTL2_TP0, 0x22222222},
	{REG_A6XX_RBBM_CLOCK_CNTL3_TP0, 0x22222222},
	{REG_A6XX_RBBM_CLOCK_CNTL4_TP0, 0x00022222},
	{REG_A6XX_RBBM_CLOCK_DELAY_TP0, 0x11111111},
	{REG_A6XX_RBBM_CLOCK_DELAY2_TP0, 0x11111111},
	{REG_A6XX_RBBM_CLOCK_DELAY3_TP0, 0x11111111},
	{REG_A6XX_RBBM_CLOCK_DELAY4_TP0, 0x00011111},
	{REG_A6XX_RBBM_CLOCK_HYST_TP0, 0x77777777},
	{REG_A6XX_RBBM_CLOCK_HYST2_TP0, 0x77777777},
	{REG_A6XX_RBBM_CLOCK_HYST3_TP0, 0x77777777},
	{REG_A6XX_RBBM_CLOCK_HYST4_TP0, 0x00077777},
	{REG_A6XX_RBBM_CLOCK_CNTL_RB0, 0x22222222},
	{REG_A6XX_RBBM_CLOCK_CNTL2_RB0, 0x01002222},
	{REG_A6XX_RBBM_CLOCK_CNTL_CCU0, 0x00002220},
	{REG_A6XX_RBBM_CLOCK_HYST_RB_CCU0, 0x00040F00},
	{REG_A6XX_RBBM_CLOCK_CNTL_RAC, 0x25222022},
	{REG_A6XX_RBBM_CLOCK_CNTL2_RAC, 0x00005555},
	{REG_A6XX_RBBM_CLOCK_DELAY_RAC, 0x00000011},
	{REG_A6XX_RBBM_CLOCK_HYST_RAC, 0x00445044},
	{REG_A6XX_RBBM_CLOCK_CNTL_TSE_RAS_RBBM, 0x04222222},
	{REG_A6XX_RBBM_CLOCK_MODE_VFD, 0x00002222},
	{REG_A6XX_RBBM_CLOCK_MODE_GPC, 0x00222222},
	{REG_A6XX_RBBM_CLOCK_DELAY_HLSQ_2, 0x00000002},
	{REG_A6XX_RBBM_CLOCK_MODE_HLSQ, 0x00002222},
	{REG_A6XX_RBBM_CLOCK_DELAY_TSE_RAS_RBBM, 0x00004000},
	{REG_A6XX_RBBM_CLOCK_DELAY_VFD, 0x00002222},
	{REG_A6XX_RBBM_CLOCK_DELAY_GPC, 0x00000200},
	{REG_A6XX_RBBM_CLOCK_DELAY_HLSQ, 0x00000000},
	{REG_A6XX_RBBM_CLOCK_HYST_TSE_RAS_RBBM, 0x00000000},
	{REG_A6XX_RBBM_CLOCK_HYST_VFD, 0x00000000},
	{REG_A6XX_RBBM_CLOCK_HYST_GPC, 0x04104004},
	{REG_A6XX_RBBM_CLOCK_HYST_HLSQ, 0x00000000},
	{REG_A6XX_RBBM_CLOCK_CNTL_TEX_FCHE, 0x00000222},
	{REG_A6XX_RBBM_CLOCK_DELAY_TEX_FCHE, 0x00000111},
	{REG_A6XX_RBBM_CLOCK_HYST_TEX_FCHE, 0x00000000},
	{REG_A6XX_RBBM_CLOCK_CNTL_UCHE, 0x22222222},
	{REG_A6XX_RBBM_CLOCK_HYST_UCHE, 0x00000004},
	{REG_A6XX_RBBM_CLOCK_DELAY_UCHE, 0x00000002},
	{REG_A6XX_RBBM_CLOCK_CNTL, 0x8AA8AA82},
	{REG_A6XX_RBBM_ISDB_CNT, 0x00000182},
	{REG_A6XX_RBBM_RAC_THRESHOLD_CNT, 0x00000000},
	{REG_A6XX_RBBM_SP_HYST_CNT, 0x00000000},
	{REG_A6XX_RBBM_CLOCK_CNTL_GMU_GX, 0x00000222},
	{REG_A6XX_RBBM_CLOCK_DELAY_GMU_GX, 0x00000111},
	{REG_A6XX_RBBM_CLOCK_HYST_GMU_GX, 0x00000555},
	{}
};

/* For a615, a616, a618, a619, a630, a640 and a680 */
static const u32 a630_protect_regs[] = {
	A6XX_PROTECT_RDONLY(0x00000, 0x04ff),
	A6XX_PROTECT_RDONLY(0x00501, 0x0005),
	A6XX_PROTECT_RDONLY(0x0050b, 0x02f4),
	A6XX_PROTECT_NORDWR(0x0050e, 0x0000),
	A6XX_PROTECT_NORDWR(0x00510, 0x0000),
	A6XX_PROTECT_NORDWR(0x00534, 0x0000),
	A6XX_PROTECT_NORDWR(0x00800, 0x0082),
	A6XX_PROTECT_NORDWR(0x008a0, 0x0008),
	A6XX_PROTECT_NORDWR(0x008ab, 0x0024),
	A6XX_PROTECT_RDONLY(0x008de, 0x00ae),
	A6XX_PROTECT_NORDWR(0x00900, 0x004d),
	A6XX_PROTECT_NORDWR(0x0098d, 0x0272),
	A6XX_PROTECT_NORDWR(0x00e00, 0x0001),
	A6XX_PROTECT_NORDWR(0x00e03, 0x000c),
	A6XX_PROTECT_NORDWR(0x03c00, 0x00c3),
	A6XX_PROTECT_RDONLY(0x03cc4, 0x1fff),
	A6XX_PROTECT_NORDWR(0x08630, 0x01cf),
	A6XX_PROTECT_NORDWR(0x08e00, 0x0000),
	A6XX_PROTECT_NORDWR(0x08e08, 0x0000),
	A6XX_PROTECT_NORDWR(0x08e50, 0x001f),
	A6XX_PROTECT_NORDWR(0x09624, 0x01db),
	A6XX_PROTECT_NORDWR(0x09e70, 0x0001),
	A6XX_PROTECT_NORDWR(0x09e78, 0x0187),
	A6XX_PROTECT_NORDWR(0x0a630, 0x01cf),
	A6XX_PROTECT_NORDWR(0x0ae02, 0x0000),
	A6XX_PROTECT_NORDWR(0x0ae50, 0x032f),
	A6XX_PROTECT_NORDWR(0x0b604, 0x0000),
	A6XX_PROTECT_NORDWR(0x0be02, 0x0001),
	A6XX_PROTECT_NORDWR(0x0be20, 0x17df),
	A6XX_PROTECT_NORDWR(0x0f000, 0x0bff),
	A6XX_PROTECT_RDONLY(0x0fc00, 0x1fff),
	A6XX_PROTECT_NORDWR(0x11c00, 0x0000), /* note: infinite range */
};
DECLARE_ADRENO_PROTECT(a630_protect, 32);

static const u32 a650_protect_regs[] = {
	A6XX_PROTECT_RDONLY(0x00000, 0x04ff),
	A6XX_PROTECT_RDONLY(0x00501, 0x0005),
	A6XX_PROTECT_RDONLY(0x0050b, 0x02f4),
	A6XX_PROTECT_NORDWR(0x0050e, 0x0000),
	A6XX_PROTECT_NORDWR(0x00510, 0x0000),
	A6XX_PROTECT_NORDWR(0x00534, 0x0000),
	A6XX_PROTECT_NORDWR(0x00800, 0x0082),
	A6XX_PROTECT_NORDWR(0x008a0, 0x0008),
	A6XX_PROTECT_NORDWR(0x008ab, 0x0024),
	A6XX_PROTECT_RDONLY(0x008de, 0x00ae),
	A6XX_PROTECT_NORDWR(0x00900, 0x004d),
	A6XX_PROTECT_NORDWR(0x0098d, 0x0272),
	A6XX_PROTECT_NORDWR(0x00e00, 0x0001),
	A6XX_PROTECT_NORDWR(0x00e03, 0x000c),
	A6XX_PROTECT_NORDWR(0x03c00, 0x00c3),
	A6XX_PROTECT_RDONLY(0x03cc4, 0x1fff),
	A6XX_PROTECT_NORDWR(0x08630, 0x01cf),
	A6XX_PROTECT_NORDWR(0x08e00, 0x0000),
	A6XX_PROTECT_NORDWR(0x08e08, 0x0000),
	A6XX_PROTECT_NORDWR(0x08e50, 0x001f),
	A6XX_PROTECT_NORDWR(0x08e80, 0x027f),
	A6XX_PROTECT_NORDWR(0x09624, 0x01db),
	A6XX_PROTECT_NORDWR(0x09e60, 0x0011),
	A6XX_PROTECT_NORDWR(0x09e78, 0x0187),
	A6XX_PROTECT_NORDWR(0x0a630, 0x01cf),
	A6XX_PROTECT_NORDWR(0x0ae02, 0x0000),
	A6XX_PROTECT_NORDWR(0x0ae50, 0x032f),
	A6XX_PROTECT_NORDWR(0x0b604, 0x0000),
	A6XX_PROTECT_NORDWR(0x0b608, 0x0007),
	A6XX_PROTECT_NORDWR(0x0be02, 0x0001),
	A6XX_PROTECT_NORDWR(0x0be20, 0x17df),
	A6XX_PROTECT_NORDWR(0x0f000, 0x0bff),
	A6XX_PROTECT_RDONLY(0x0fc00, 0x1fff),
	A6XX_PROTECT_NORDWR(0x18400, 0x1fff),
	A6XX_PROTECT_NORDWR(0x1a800, 0x1fff),
	A6XX_PROTECT_NORDWR(0x1f400, 0x0443),
	A6XX_PROTECT_RDONLY(0x1f844, 0x007b),
	A6XX_PROTECT_NORDWR(0x1f887, 0x001b),
	A6XX_PROTECT_NORDWR(0x1f8c0, 0x0000), /* note: infinite range */
};
DECLARE_ADRENO_PROTECT(a650_protect, 48);

/* These are for a635 and a660 */
static const u32 a660_protect_regs[] = {
	A6XX_PROTECT_RDONLY(0x00000, 0x04ff),
	A6XX_PROTECT_RDONLY(0x00501, 0x0005),
	A6XX_PROTECT_RDONLY(0x0050b, 0x02f4),
	A6XX_PROTECT_NORDWR(0x0050e, 0x0000),
	A6XX_PROTECT_NORDWR(0x00510, 0x0000),
	A6XX_PROTECT_NORDWR(0x00534, 0x0000),
	A6XX_PROTECT_NORDWR(0x00800, 0x0082),
	A6XX_PROTECT_NORDWR(0x008a0, 0x0008),
	A6XX_PROTECT_NORDWR(0x008ab, 0x0024),
	A6XX_PROTECT_RDONLY(0x008de, 0x00ae),
	A6XX_PROTECT_NORDWR(0x00900, 0x004d),
	A6XX_PROTECT_NORDWR(0x0098d, 0x0272),
	A6XX_PROTECT_NORDWR(0x00e00, 0x0001),
	A6XX_PROTECT_NORDWR(0x00e03, 0x000c),
	A6XX_PROTECT_NORDWR(0x03c00, 0x00c3),
	A6XX_PROTECT_RDONLY(0x03cc4, 0x1fff),
	A6XX_PROTECT_NORDWR(0x08630, 0x01cf),
	A6XX_PROTECT_NORDWR(0x08e00, 0x0000),
	A6XX_PROTECT_NORDWR(0x08e08, 0x0000),
	A6XX_PROTECT_NORDWR(0x08e50, 0x001f),
	A6XX_PROTECT_NORDWR(0x08e80, 0x027f),
	A6XX_PROTECT_NORDWR(0x09624, 0x01db),
	A6XX_PROTECT_NORDWR(0x09e60, 0x0011),
	A6XX_PROTECT_NORDWR(0x09e78, 0x0187),
	A6XX_PROTECT_NORDWR(0x0a630, 0x01cf),
	A6XX_PROTECT_NORDWR(0x0ae02, 0x0000),
	A6XX_PROTECT_NORDWR(0x0ae50, 0x012f),
	A6XX_PROTECT_NORDWR(0x0b604, 0x0000),
	A6XX_PROTECT_NORDWR(0x0b608, 0x0006),
	A6XX_PROTECT_NORDWR(0x0be02, 0x0001),
	A6XX_PROTECT_NORDWR(0x0be20, 0x015f),
	A6XX_PROTECT_NORDWR(0x0d000, 0x05ff),
	A6XX_PROTECT_NORDWR(0x0f000, 0x0bff),
	A6XX_PROTECT_RDONLY(0x0fc00, 0x1fff),
	A6XX_PROTECT_NORDWR(0x18400, 0x1fff),
	A6XX_PROTECT_NORDWR(0x1a400, 0x1fff),
	A6XX_PROTECT_NORDWR(0x1f400, 0x0443),
	A6XX_PROTECT_RDONLY(0x1f844, 0x007b),
	A6XX_PROTECT_NORDWR(0x1f860, 0x0000),
	A6XX_PROTECT_NORDWR(0x1f887, 0x001b),
	A6XX_PROTECT_NORDWR(0x1f8c0, 0x0000), /* note: infinite range */
};
DECLARE_ADRENO_PROTECT(a660_protect, 48);

/* These are for a690 */
static const u32 a690_protect_regs[] = {
	A6XX_PROTECT_RDONLY(0x00000, 0x004ff),
	A6XX_PROTECT_RDONLY(0x00501, 0x00001),
	A6XX_PROTECT_RDONLY(0x0050b, 0x002f4),
	A6XX_PROTECT_NORDWR(0x0050e, 0x00000),
	A6XX_PROTECT_NORDWR(0x00510, 0x00000),
	A6XX_PROTECT_NORDWR(0x00534, 0x00000),
	A6XX_PROTECT_NORDWR(0x00800, 0x00082),
	A6XX_PROTECT_NORDWR(0x008a0, 0x00008),
	A6XX_PROTECT_NORDWR(0x008ab, 0x00024),
	A6XX_PROTECT_RDONLY(0x008de, 0x000ae),
	A6XX_PROTECT_NORDWR(0x00900, 0x0004d),
	A6XX_PROTECT_NORDWR(0x0098d, 0x00272),
	A6XX_PROTECT_NORDWR(0x00e00, 0x00001),
	A6XX_PROTECT_NORDWR(0x00e03, 0x0000c),
	A6XX_PROTECT_NORDWR(0x03c00, 0x000c3),
	A6XX_PROTECT_RDONLY(0x03cc4, 0x01fff),
	A6XX_PROTECT_NORDWR(0x08630, 0x001cf),
	A6XX_PROTECT_NORDWR(0x08e00, 0x00000),
	A6XX_PROTECT_NORDWR(0x08e08, 0x00007),
	A6XX_PROTECT_NORDWR(0x08e50, 0x0001f),
	A6XX_PROTECT_NORDWR(0x08e80, 0x0027f),
	A6XX_PROTECT_NORDWR(0x09624, 0x001db),
	A6XX_PROTECT_NORDWR(0x09e60, 0x00011),
	A6XX_PROTECT_NORDWR(0x09e78, 0x00187),
	A6XX_PROTECT_NORDWR(0x0a630, 0x001cf),
	A6XX_PROTECT_NORDWR(0x0ae02, 0x00000),
	A6XX_PROTECT_NORDWR(0x0ae50, 0x0012f),
	A6XX_PROTECT_NORDWR(0x0b604, 0x00000),
	A6XX_PROTECT_NORDWR(0x0b608, 0x00006),
	A6XX_PROTECT_NORDWR(0x0be02, 0x00001),
	A6XX_PROTECT_NORDWR(0x0be20, 0x0015f),
	A6XX_PROTECT_NORDWR(0x0d000, 0x005ff),
	A6XX_PROTECT_NORDWR(0x0f000, 0x00bff),
	A6XX_PROTECT_RDONLY(0x0fc00, 0x01fff),
	A6XX_PROTECT_NORDWR(0x11c00, 0x00000), /*note: infiite range */
};
DECLARE_ADRENO_PROTECT(a690_protect, 48);

static const struct adreno_reglist a640_gbif[] = {
	{ REG_A6XX_GBIF_QSB_SIDE0, 0x00071620 },
	{ REG_A6XX_GBIF_QSB_SIDE1, 0x00071620 },
	{ REG_A6XX_GBIF_QSB_SIDE2, 0x00071620 },
	{ REG_A6XX_GBIF_QSB_SIDE3, 0x00071620 },
	{ },
};

static const struct adreno_info a6xx_gpus[] = {
	{
		.chip_ids = ADRENO_CHIP_IDS(0x06010000),
		.family = ADRENO_6XX_GEN1,
		.revn = 610,
		.fw = {
			[ADRENO_FW_SQE] = "/*(DEBLOBBED)*/",
		},
		.gmem = (SZ_128K + SZ_4K),
		.quirks = ADRENO_QUIRK_4GB_VA,
		.inactive_period = DRM_MSM_INACTIVE_PERIOD,
		.funcs = &a6xx_gmuwrapper_funcs,
		.zapfw = "/*(DEBLOBBED)*/",
		.a6xx = &(const struct a6xx_info) {
			.hwcg = a612_hwcg,
			.protect = &a630_protect,
			.gbif_cx = a640_gbif,
			.gmu_cgc_mode = 0x00020202,
			.prim_fifo_threshold = 0x00080000,
		},
		/*
		 * There are (at least) three SoCs implementing A610: SM6125
		 * (trinket), SM6115 (bengal) and SM6225 (khaje). Trinket does
		 * not have speedbinning, as only a single SKU exists and we
		 * don't support khaje upstream yet.  Hence, this matching
		 * table is only valid for bengal.
		 */
		.speedbins = ADRENO_SPEEDBINS(
			{ 0,   0 },
			{ 206, 1 },
			{ 200, 2 },
			{ 157, 3 },
			{ 127, 4 },
		),
	}, {
		.chip_ids = ADRENO_CHIP_IDS(0x06010200),
		.family = ADRENO_6XX_GEN1,
		.fw = {
			[ADRENO_FW_SQE] = "/*(DEBLOBBED)*/",
			[ADRENO_FW_GMU] = "/*(DEBLOBBED)*/",
		},
		.gmem = (SZ_128K + SZ_4K),
		.inactive_period = DRM_MSM_INACTIVE_PERIOD,
		.funcs = &a6xx_gmuwrapper_funcs,
		.a6xx = &(const struct a6xx_info) {
			.hwcg = a612_hwcg,
			.protect = &a630_protect,
			.gmu_cgc_mode = 0x00000022,
			.prim_fifo_threshold = 0x00080000,
		},
	}, {
		.chip_ids = ADRENO_CHIP_IDS(0x06010500),
		.family = ADRENO_6XX_GEN1,
		.revn = 615,
		.fw = {
			[ADRENO_FW_SQE] = "/*(DEBLOBBED)*/",
			[ADRENO_FW_GMU] = "/*(DEBLOBBED)*/",
		},
		.gmem = SZ_512K,
		.quirks = ADRENO_QUIRK_4GB_VA,
		.inactive_period = DRM_MSM_INACTIVE_PERIOD,
		.funcs = &a6xx_gpu_funcs,
		.zapfw = "/*(DEBLOBBED)*/",
		.a6xx = &(const struct a6xx_info) {
			.hwcg = a615_hwcg,
			.protect = &a630_protect,
			.gmu_cgc_mode = 0x00000222,
			.prim_fifo_threshold = 0x0018000,
		},
		.speedbins = ADRENO_SPEEDBINS(
			/*
			 * The default speed bin (0) has the same values as
			 * speed bin 90 which goes up to 432 MHz.
			 */
			{ 0,   0 },
			{ 90,  0 },
			{ 105, 1 },
			{ 146, 2 },
			{ 163, 3 },
		),
	}, {
		.machine = "qcom,sm7150",
		.chip_ids = ADRENO_CHIP_IDS(0x06010800),
		.family = ADRENO_6XX_GEN1,
		.fw = {
			[ADRENO_FW_SQE] = "/*(DEBLOBBED)*/",
			[ADRENO_FW_GMU] = "/*(DEBLOBBED)*/",
		},
		.gmem = SZ_512K,
		.inactive_period = DRM_MSM_INACTIVE_PERIOD,
		.quirks = ADRENO_QUIRK_HAS_CACHED_COHERENT |
			  ADRENO_QUIRK_4GB_VA,
		.funcs = &a6xx_gpu_funcs,
		.zapfw = "/*(DEBLOBBED)*/",
		.a6xx = &(const struct a6xx_info) {
			.hwcg = a615_hwcg,
			.protect = &a630_protect,
			.gmu_cgc_mode = 0x00000222,
			.prim_fifo_threshold = 0x00180000,
		},
		.speedbins = ADRENO_SPEEDBINS(
			{ 0,   0 },
			{ 128, 1 },
			{ 146, 2 },
			{ 167, 3 },
			{ 172, 4 },
		),
	}, {
		.chip_ids = ADRENO_CHIP_IDS(0x06010800),
		.family = ADRENO_6XX_GEN1,
		.revn = 618,
		.fw = {
			[ADRENO_FW_SQE] = "/*(DEBLOBBED)*/",
			[ADRENO_FW_GMU] = "/*(DEBLOBBED)*/",
		},
		.gmem = SZ_512K,
		.inactive_period = DRM_MSM_INACTIVE_PERIOD,
		.quirks = ADRENO_QUIRK_HAS_CACHED_COHERENT |
			  ADRENO_QUIRK_4GB_VA,
		.funcs = &a6xx_gpu_funcs,
		.a6xx = &(const struct a6xx_info) {
			.protect = &a630_protect,
			.gmu_cgc_mode = 0x00000222,
			.prim_fifo_threshold = 0x00180000,
		},
		.speedbins = ADRENO_SPEEDBINS(
			{ 0,   0 },
			{ 169, 1 },
			{ 174, 2 },
		),
	}, {
		.machine = "qcom,sm4350",
		.chip_ids = ADRENO_CHIP_IDS(0x06010900),
		.family = ADRENO_6XX_GEN1,
		.revn = 619,
		.fw = {
			[ADRENO_FW_SQE] = "/*(DEBLOBBED)*/",
			[ADRENO_FW_GMU] = "/*(DEBLOBBED)*/",
		},
		.gmem = SZ_512K,
		.quirks = ADRENO_QUIRK_4GB_VA,
		.inactive_period = DRM_MSM_INACTIVE_PERIOD,
		.funcs = &a6xx_gpu_funcs,
		.zapfw = "/*(DEBLOBBED)*/",
		.a6xx = &(const struct a6xx_info) {
			.hwcg = a615_hwcg,
			.protect = &a630_protect,
			.gmu_cgc_mode = 0x00000222,
			.prim_fifo_threshold = 0x00018000,
		},
		.speedbins = ADRENO_SPEEDBINS(
			{ 0,   0 },
			{ 138, 1 },
			{ 92,  2 },
		),
	}, {
		.machine = "qcom,sm6375",
		.chip_ids = ADRENO_CHIP_IDS(0x06010901),
		.family = ADRENO_6XX_GEN1,
		.revn = 619,
		.fw = {
			[ADRENO_FW_SQE] = "/*(DEBLOBBED)*/",
			[ADRENO_FW_GMU] = "/*(DEBLOBBED)*/",
		},
		.gmem = SZ_512K,
		.quirks = ADRENO_QUIRK_4GB_VA,
		.inactive_period = DRM_MSM_INACTIVE_PERIOD,
		.funcs = &a6xx_gpu_funcs,
		.zapfw = "/*(DEBLOBBED)*/",
		.a6xx = &(const struct a6xx_info) {
			.hwcg = a615_hwcg,
			.protect = &a630_protect,
			.gmu_cgc_mode = 0x00000222,
			.prim_fifo_threshold = 0x00018000,
		},
		.speedbins = ADRENO_SPEEDBINS(
			{ 0,   0 },
			{ 190, 1 },
			{ 177, 2 },
		),
	}, {
		.chip_ids = ADRENO_CHIP_IDS(0x06010900),
		.family = ADRENO_6XX_GEN1,
		.revn = 619,
		.fw = {
			[ADRENO_FW_SQE] = "/*(DEBLOBBED)*/",
			[ADRENO_FW_GMU] = "/*(DEBLOBBED)*/",
		},
		.gmem = SZ_512K,
		.quirks = ADRENO_QUIRK_HAS_CACHED_COHERENT |
			  ADRENO_QUIRK_4GB_VA,
		.inactive_period = DRM_MSM_INACTIVE_PERIOD,
		.funcs = &a6xx_gpu_funcs,
		.zapfw = "/*(DEBLOBBED)*/",
		.a6xx = &(const struct a6xx_info) {
			.hwcg = a615_hwcg,
			.protect = &a630_protect,
			.gmu_cgc_mode = 0x00000222,
			.prim_fifo_threshold = 0x00018000,
		},
		.speedbins = ADRENO_SPEEDBINS(
			{ 0,   0 },
			{ 120, 4 },
			{ 138, 3 },
			{ 169, 2 },
			{ 180, 1 },
		),
	}, {
		.chip_ids = ADRENO_CHIP_IDS(0x06020100),
		.family = ADRENO_6XX_GEN3,
		.fw = {
			[ADRENO_FW_SQE] = "/*(DEBLOBBED)*/",
			[ADRENO_FW_GMU] = "/*(DEBLOBBED)*/",
		},
		.gmem = SZ_512K,
		.inactive_period = DRM_MSM_INACTIVE_PERIOD,
		.quirks = ADRENO_QUIRK_HAS_CACHED_COHERENT |
			  ADRENO_QUIRK_HAS_HW_APRIV,
		.funcs = &a6xx_gpu_funcs,
		.zapfw = "/*(DEBLOBBED)*/",
		.a6xx = &(const struct a6xx_info) {
			.hwcg = a620_hwcg,
			.protect = &a650_protect,
			.gbif_cx = a640_gbif,
			.gmu_cgc_mode = 0x00020200,
			.prim_fifo_threshold = 0x00010000,
		},
		.speedbins = ADRENO_SPEEDBINS(
			{ 0, 0 },
			{ 137, 1 },
		),
	}, {
		.chip_ids = ADRENO_CHIP_IDS(0x06020300),
		.family = ADRENO_6XX_GEN3,
		.fw = {
			[ADRENO_FW_SQE] = "/*(DEBLOBBED)*/",
			[ADRENO_FW_GMU] = "/*(DEBLOBBED)*/",
		},
		.gmem = SZ_512K,
		.inactive_period = DRM_MSM_INACTIVE_PERIOD,
		.quirks = ADRENO_QUIRK_HAS_CACHED_COHERENT |
			ADRENO_QUIRK_HAS_HW_APRIV,
		.funcs = &a6xx_gpu_funcs,
		.a6xx = &(const struct a6xx_info) {
			.hwcg = a690_hwcg,
			.protect = &a650_protect,
			.gbif_cx = a640_gbif,
			.gmu_cgc_mode = 0x00020200,
			.prim_fifo_threshold = 0x00010000,
			.bcms = (const struct a6xx_bcm[]) {
				{ .name = "SH0", .buswidth = 16 },
				{ .name = "MC0", .buswidth = 4 },
				{
					.name = "ACV",
					.fixed = true,
					.perfmode = BIT(3),
				},
				{ /* sentinel */ },
			},
		},
		.speedbins = ADRENO_SPEEDBINS(
			{ 0,   0 },
			{ 185, 0 },
			{ 127, 1 },
		),
	}, {
		.chip_ids = ADRENO_CHIP_IDS(
			0x06030001,
			0x06030002
		),
		.family = ADRENO_6XX_GEN1,
		.revn = 630,
		.fw = {
			[ADRENO_FW_SQE] = "/*(DEBLOBBED)*/",
			[ADRENO_FW_GMU] = "/*(DEBLOBBED)*/",
		},
		.gmem = SZ_1M,
		.quirks = ADRENO_QUIRK_HAS_CACHED_COHERENT |
			  ADRENO_QUIRK_4GB_VA,
		.inactive_period = DRM_MSM_INACTIVE_PERIOD,
		.funcs = &a6xx_gpu_funcs,
		.zapfw = "/*(DEBLOBBED)*/",
		.a6xx = &(const struct a6xx_info) {
			.hwcg = a630_hwcg,
			.protect = &a630_protect,
			.gmu_cgc_mode = 0x00020202,
			.prim_fifo_threshold = 0x00180000,
		},
	}, {
		.chip_ids = ADRENO_CHIP_IDS(0x06040001),
		.family = ADRENO_6XX_GEN2,
		.revn = 640,
		.fw = {
			[ADRENO_FW_SQE] = "/*(DEBLOBBED)*/",
			[ADRENO_FW_GMU] = "/*(DEBLOBBED)*/",
		},
		.gmem = SZ_1M,
		.quirks = ADRENO_QUIRK_HAS_CACHED_COHERENT |
			  ADRENO_QUIRK_4GB_VA,
		.inactive_period = DRM_MSM_INACTIVE_PERIOD,
		.funcs = &a6xx_gpu_funcs,
		.zapfw = "/*(DEBLOBBED)*/",
		.a6xx = &(const struct a6xx_info) {
			.hwcg = a640_hwcg,
			.protect = &a630_protect,
			.gmu_cgc_mode = 0x00020202,
			.prim_fifo_threshold = 0x00180000,
		},
		.speedbins = ADRENO_SPEEDBINS(
			{ 0, 0 },
			{ 1, 1 },
		),
	}, {
		.chip_ids = ADRENO_CHIP_IDS(0x06050002),
		.family = ADRENO_6XX_GEN3,
		.revn = 650,
		.fw = {
			[ADRENO_FW_SQE] = "/*(DEBLOBBED)*/",
			[ADRENO_FW_GMU] = "/*(DEBLOBBED)*/",
		},
		.gmem = SZ_1M + SZ_128K,
		.inactive_period = DRM_MSM_INACTIVE_PERIOD,
		.quirks = ADRENO_QUIRK_HAS_CACHED_COHERENT |
			ADRENO_QUIRK_HAS_HW_APRIV,
		.funcs = &a6xx_gpu_funcs,
		.zapfw = "/*(DEBLOBBED)*/",
		.a6xx = &(const struct a6xx_info) {
			.hwcg = a650_hwcg,
			.protect = &a650_protect,
			.gbif_cx = a640_gbif,
			.gmu_cgc_mode = 0x00020202,
			.prim_fifo_threshold = 0x00300200,
		},
		.speedbins = ADRENO_SPEEDBINS(
			{ 0, 0 },
			{ 1, 1 },
			{ 2, 3 }, /* Yep, 2 and 3 are swapped! :/ */
			{ 3, 2 },
		),
	}, {
		.chip_ids = ADRENO_CHIP_IDS(0x06060001),
		.family = ADRENO_6XX_GEN4,
		.revn = 660,
		.fw = {
			[ADRENO_FW_SQE] = "/*(DEBLOBBED)*/",
			[ADRENO_FW_GMU] = "/*(DEBLOBBED)*/",
		},
		.gmem = SZ_1M + SZ_512K,
		.inactive_period = DRM_MSM_INACTIVE_PERIOD,
		.quirks = ADRENO_QUIRK_HAS_CACHED_COHERENT |
			ADRENO_QUIRK_HAS_HW_APRIV,
		.funcs = &a6xx_gpu_funcs,
		.zapfw = "/*(DEBLOBBED)*/",
		.a6xx = &(const struct a6xx_info) {
			.hwcg = a660_hwcg,
			.protect = &a660_protect,
			.gbif_cx = a640_gbif,
			.gmu_cgc_mode = 0x00020000,
			.prim_fifo_threshold = 0x00300200,
		},
	}, {
		.chip_ids = ADRENO_CHIP_IDS(0x06060300),
		.family = ADRENO_6XX_GEN4,
		.fw = {
			[ADRENO_FW_SQE] = "/*(DEBLOBBED)*/",
			[ADRENO_FW_GMU] = "/*(DEBLOBBED)*/",
		},
		.gmem = SZ_1M + SZ_512K,
		.inactive_period = DRM_MSM_INACTIVE_PERIOD,
		.quirks = ADRENO_QUIRK_HAS_CACHED_COHERENT |
			ADRENO_QUIRK_HAS_HW_APRIV,
		.funcs = &a6xx_gpu_funcs,
		.a6xx = &(const struct a6xx_info) {
			.hwcg = a690_hwcg,
			.protect = &a660_protect,
			.gbif_cx = a640_gbif,
			.gmu_cgc_mode = 0x00020200,
			.prim_fifo_threshold = 0x00300200,
		},
		.speedbins = ADRENO_SPEEDBINS(
			{ 0,   0 },
			{ 169, 0 },
			{ 113, 1 },
		),
	}, {
		.chip_ids = ADRENO_CHIP_IDS(0x06030500),
		.family = ADRENO_6XX_GEN4,
		.fw = {
			[ADRENO_FW_SQE] = "/*(DEBLOBBED)*/",
			[ADRENO_FW_GMU] = "/*(DEBLOBBED)*/",
		},
		.gmem = SZ_512K,
		.inactive_period = DRM_MSM_INACTIVE_PERIOD,
		.quirks = ADRENO_QUIRK_HAS_CACHED_COHERENT |
			ADRENO_QUIRK_HAS_HW_APRIV,
		.funcs = &a6xx_gpu_funcs,
		.zapfw = "/*(DEBLOBBED)*/",
		.a6xx = &(const struct a6xx_info) {
			.hwcg = a660_hwcg,
			.protect = &a660_protect,
			.gbif_cx = a640_gbif,
			.gmu_cgc_mode = 0x00020202,
			.prim_fifo_threshold = 0x00200200,
		},
		.speedbins = ADRENO_SPEEDBINS(
			{ 0,   0 },
			{ 117, 0 },
			{ 129, 4 },
			{ 172, 2 }, /* Called speedbin 1 downstream, but let's not break things! */
			{ 190, 1 },
		),
	}, {
		.chip_ids = ADRENO_CHIP_IDS(0x06080001),
		.family = ADRENO_6XX_GEN2,
		.revn = 680,
		.fw = {
			[ADRENO_FW_SQE] = "/*(DEBLOBBED)*/",
			[ADRENO_FW_GMU] = "/*(DEBLOBBED)*/",
		},
		.gmem = SZ_2M,
		.quirks = ADRENO_QUIRK_HAS_CACHED_COHERENT |
			  ADRENO_QUIRK_4GB_VA,
		.inactive_period = DRM_MSM_INACTIVE_PERIOD,
		.funcs = &a6xx_gpu_funcs,
		.zapfw = "/*(DEBLOBBED)*/",
		.a6xx = &(const struct a6xx_info) {
			.hwcg = a640_hwcg,
			.protect = &a630_protect,
			.gmu_cgc_mode = 0x00020202,
			.prim_fifo_threshold = 0x00200200,
		},
	}, {
		.chip_ids = ADRENO_CHIP_IDS(0x06090000),
		.family = ADRENO_6XX_GEN4,
		.fw = {
			[ADRENO_FW_SQE] = "/*(DEBLOBBED)*/",
			[ADRENO_FW_GMU] = "/*(DEBLOBBED)*/",
		},
		.gmem = SZ_4M,
		.inactive_period = DRM_MSM_INACTIVE_PERIOD,
		.quirks = ADRENO_QUIRK_HAS_CACHED_COHERENT |
			ADRENO_QUIRK_HAS_HW_APRIV,
		.funcs = &a6xx_gpu_funcs,
		.zapfw = "/*(DEBLOBBED)*/",
		.a6xx = &(const struct a6xx_info) {
			.hwcg = a690_hwcg,
			.protect = &a690_protect,
			.gbif_cx = a640_gbif,
			.gmu_cgc_mode = 0x00020200,
			.prim_fifo_threshold = 0x00800200,
		},
	}
};
DECLARE_ADRENO_GPULIST(a6xx);

static const struct adreno_reglist a702_hwcg[] = {
	{ REG_A6XX_RBBM_CLOCK_CNTL_SP0, 0x22222222 },
	{ REG_A6XX_RBBM_CLOCK_CNTL2_SP0, 0x02222220 },
	{ REG_A6XX_RBBM_CLOCK_DELAY_SP0, 0x00000081 },
	{ REG_A6XX_RBBM_CLOCK_HYST_SP0, 0x0000f3cf },
	{ REG_A6XX_RBBM_CLOCK_CNTL_TP0, 0x22222222 },
	{ REG_A6XX_RBBM_CLOCK_CNTL2_TP0, 0x22222222 },
	{ REG_A6XX_RBBM_CLOCK_CNTL3_TP0, 0x22222222 },
	{ REG_A6XX_RBBM_CLOCK_CNTL4_TP0, 0x00022222 },
	{ REG_A6XX_RBBM_CLOCK_DELAY_TP0, 0x11111111 },
	{ REG_A6XX_RBBM_CLOCK_DELAY2_TP0, 0x11111111 },
	{ REG_A6XX_RBBM_CLOCK_DELAY3_TP0, 0x11111111 },
	{ REG_A6XX_RBBM_CLOCK_DELAY4_TP0, 0x00011111 },
	{ REG_A6XX_RBBM_CLOCK_HYST_TP0, 0x77777777 },
	{ REG_A6XX_RBBM_CLOCK_HYST2_TP0, 0x77777777 },
	{ REG_A6XX_RBBM_CLOCK_HYST3_TP0, 0x77777777 },
	{ REG_A6XX_RBBM_CLOCK_HYST4_TP0, 0x00077777 },
	{ REG_A6XX_RBBM_CLOCK_CNTL_RB0, 0x22222222 },
	{ REG_A6XX_RBBM_CLOCK_CNTL2_RB0, 0x01202222 },
	{ REG_A6XX_RBBM_CLOCK_CNTL_CCU0, 0x00002220 },
	{ REG_A6XX_RBBM_CLOCK_HYST_RB_CCU0, 0x00040f00 },
	{ REG_A6XX_RBBM_CLOCK_CNTL_RAC, 0x05522022 },
	{ REG_A6XX_RBBM_CLOCK_CNTL2_RAC, 0x00005555 },
	{ REG_A6XX_RBBM_CLOCK_DELAY_RAC, 0x00000011 },
	{ REG_A6XX_RBBM_CLOCK_HYST_RAC, 0x00445044 },
	{ REG_A6XX_RBBM_CLOCK_CNTL_TSE_RAS_RBBM, 0x04222222 },
	{ REG_A6XX_RBBM_CLOCK_MODE_VFD, 0x00002222 },
	{ REG_A6XX_RBBM_CLOCK_MODE_GPC, 0x02222222 },
	{ REG_A6XX_RBBM_CLOCK_DELAY_HLSQ_2, 0x00000002 },
	{ REG_A6XX_RBBM_CLOCK_MODE_HLSQ, 0x00002222 },
	{ REG_A6XX_RBBM_CLOCK_DELAY_TSE_RAS_RBBM, 0x00004000 },
	{ REG_A6XX_RBBM_CLOCK_DELAY_VFD, 0x00002222 },
	{ REG_A6XX_RBBM_CLOCK_DELAY_GPC, 0x00000200 },
	{ REG_A6XX_RBBM_CLOCK_DELAY_HLSQ, 0x00000000 },
	{ REG_A6XX_RBBM_CLOCK_HYST_TSE_RAS_RBBM, 0x00000000 },
	{ REG_A6XX_RBBM_CLOCK_HYST_VFD, 0x00000000 },
	{ REG_A6XX_RBBM_CLOCK_HYST_GPC, 0x04104004 },
	{ REG_A6XX_RBBM_CLOCK_HYST_HLSQ, 0x00000000 },
	{ REG_A6XX_RBBM_CLOCK_CNTL_UCHE, 0x22222222 },
	{ REG_A6XX_RBBM_CLOCK_HYST_UCHE, 0x00000004 },
	{ REG_A6XX_RBBM_CLOCK_DELAY_UCHE, 0x00000002 },
	{ REG_A6XX_RBBM_ISDB_CNT, 0x00000182 },
	{ REG_A6XX_RBBM_RAC_THRESHOLD_CNT, 0x00000000 },
	{ REG_A6XX_RBBM_SP_HYST_CNT, 0x00000000 },
	{ REG_A6XX_RBBM_CLOCK_CNTL_GMU_GX, 0x00000222 },
	{ REG_A6XX_RBBM_CLOCK_DELAY_GMU_GX, 0x00000111 },
	{ REG_A6XX_RBBM_CLOCK_HYST_GMU_GX, 0x00000555 },
	{ REG_A6XX_RBBM_CLOCK_CNTL_FCHE, 0x00000222 },
	{ REG_A6XX_RBBM_CLOCK_DELAY_FCHE, 0x00000000 },
	{ REG_A6XX_RBBM_CLOCK_HYST_FCHE, 0x00000000 },
	{ REG_A6XX_RBBM_CLOCK_CNTL_GLC, 0x00222222 },
	{ REG_A6XX_RBBM_CLOCK_DELAY_GLC, 0x00000000 },
	{ REG_A6XX_RBBM_CLOCK_HYST_GLC, 0x00000000 },
	{ REG_A6XX_RBBM_CLOCK_CNTL_MHUB, 0x00000002 },
	{ REG_A6XX_RBBM_CLOCK_DELAY_MHUB, 0x00000000 },
	{ REG_A6XX_RBBM_CLOCK_HYST_MHUB, 0x00000000 },
	{}
};

static const struct adreno_reglist a730_hwcg[] = {
	{ REG_A6XX_RBBM_CLOCK_CNTL_SP0, 0x02222222 },
	{ REG_A6XX_RBBM_CLOCK_CNTL2_SP0, 0x02022222 },
	{ REG_A6XX_RBBM_CLOCK_HYST_SP0, 0x0000f3cf },
	{ REG_A6XX_RBBM_CLOCK_DELAY_SP0, 0x00000080 },
	{ REG_A6XX_RBBM_CLOCK_CNTL_TP0, 0x22222220 },
	{ REG_A6XX_RBBM_CLOCK_CNTL2_TP0, 0x22222222 },
	{ REG_A6XX_RBBM_CLOCK_CNTL3_TP0, 0x22222222 },
	{ REG_A6XX_RBBM_CLOCK_CNTL4_TP0, 0x00222222 },
	{ REG_A6XX_RBBM_CLOCK_HYST_TP0, 0x77777777 },
	{ REG_A6XX_RBBM_CLOCK_HYST2_TP0, 0x77777777 },
	{ REG_A6XX_RBBM_CLOCK_HYST3_TP0, 0x77777777 },
	{ REG_A6XX_RBBM_CLOCK_HYST4_TP0, 0x00077777 },
	{ REG_A6XX_RBBM_CLOCK_DELAY_TP0, 0x11111111 },
	{ REG_A6XX_RBBM_CLOCK_DELAY2_TP0, 0x11111111 },
	{ REG_A6XX_RBBM_CLOCK_DELAY3_TP0, 0x11111111 },
	{ REG_A6XX_RBBM_CLOCK_DELAY4_TP0, 0x00011111 },
	{ REG_A6XX_RBBM_CLOCK_CNTL_UCHE, 0x22222222 },
	{ REG_A6XX_RBBM_CLOCK_HYST_UCHE, 0x00000004 },
	{ REG_A6XX_RBBM_CLOCK_DELAY_UCHE, 0x00000002 },
	{ REG_A6XX_RBBM_CLOCK_CNTL_RB0, 0x22222222 },
	{ REG_A6XX_RBBM_CLOCK_CNTL2_RB0, 0x01002222 },
	{ REG_A6XX_RBBM_CLOCK_CNTL_CCU0, 0x00002220 },
	{ REG_A6XX_RBBM_CLOCK_HYST_RB_CCU0, 0x44000f00 },
	{ REG_A6XX_RBBM_CLOCK_CNTL_RAC, 0x25222022 },
	{ REG_A6XX_RBBM_CLOCK_CNTL2_RAC, 0x00555555 },
	{ REG_A6XX_RBBM_CLOCK_DELAY_RAC, 0x00000011 },
	{ REG_A6XX_RBBM_CLOCK_HYST_RAC, 0x00440044 },
	{ REG_A6XX_RBBM_CLOCK_CNTL_TSE_RAS_RBBM, 0x04222222 },
	{ REG_A7XX_RBBM_CLOCK_MODE2_GRAS, 0x00000222 },
	{ REG_A7XX_RBBM_CLOCK_MODE_BV_GRAS, 0x00222222 },
	{ REG_A6XX_RBBM_CLOCK_MODE_GPC, 0x02222223 },
	{ REG_A6XX_RBBM_CLOCK_MODE_VFD, 0x00002222 },
	{ REG_A7XX_RBBM_CLOCK_MODE_BV_GPC, 0x00222222 },
	{ REG_A7XX_RBBM_CLOCK_MODE_BV_VFD, 0x00002222 },
	{ REG_A6XX_RBBM_CLOCK_HYST_TSE_RAS_RBBM, 0x00000000 },
	{ REG_A6XX_RBBM_CLOCK_HYST_GPC, 0x04104004 },
	{ REG_A6XX_RBBM_CLOCK_HYST_VFD, 0x00000000 },
	{ REG_A6XX_RBBM_CLOCK_DELAY_TSE_RAS_RBBM, 0x00004000 },
	{ REG_A6XX_RBBM_CLOCK_DELAY_GPC, 0x00000200 },
	{ REG_A6XX_RBBM_CLOCK_DELAY_VFD, 0x00002222 },
	{ REG_A6XX_RBBM_CLOCK_MODE_HLSQ, 0x00002222 },
	{ REG_A6XX_RBBM_CLOCK_DELAY_HLSQ, 0x00000000 },
	{ REG_A6XX_RBBM_CLOCK_HYST_HLSQ, 0x00000000 },
	{ REG_A6XX_RBBM_CLOCK_DELAY_HLSQ_2, 0x00000002 },
	{ REG_A7XX_RBBM_CLOCK_MODE_BV_LRZ, 0x55555552 },
	{ REG_A7XX_RBBM_CLOCK_MODE_CP, 0x00000223 },
	{ REG_A6XX_RBBM_CLOCK_CNTL, 0x8aa8aa82 },
	{ REG_A6XX_RBBM_ISDB_CNT, 0x00000182 },
	{ REG_A6XX_RBBM_RAC_THRESHOLD_CNT, 0x00000000 },
	{ REG_A6XX_RBBM_SP_HYST_CNT, 0x00000000 },
	{ REG_A6XX_RBBM_CLOCK_CNTL_GMU_GX, 0x00000222 },
	{ REG_A6XX_RBBM_CLOCK_DELAY_GMU_GX, 0x00000111 },
	{ REG_A6XX_RBBM_CLOCK_HYST_GMU_GX, 0x00000555 },
	{},
};

static const struct adreno_reglist a740_hwcg[] = {
	{ REG_A6XX_RBBM_CLOCK_CNTL_SP0, 0x02222222 },
	{ REG_A6XX_RBBM_CLOCK_CNTL2_SP0, 0x22022222 },
	{ REG_A6XX_RBBM_CLOCK_HYST_SP0, 0x003cf3cf },
	{ REG_A6XX_RBBM_CLOCK_DELAY_SP0, 0x00000080 },
	{ REG_A6XX_RBBM_CLOCK_CNTL_TP0, 0x22222220 },
	{ REG_A6XX_RBBM_CLOCK_CNTL2_TP0, 0x22222222 },
	{ REG_A6XX_RBBM_CLOCK_CNTL3_TP0, 0x22222222 },
	{ REG_A6XX_RBBM_CLOCK_CNTL4_TP0, 0x00222222 },
	{ REG_A6XX_RBBM_CLOCK_HYST_TP0, 0x77777777 },
	{ REG_A6XX_RBBM_CLOCK_HYST2_TP0, 0x77777777 },
	{ REG_A6XX_RBBM_CLOCK_HYST3_TP0, 0x77777777 },
	{ REG_A6XX_RBBM_CLOCK_HYST4_TP0, 0x00077777 },
	{ REG_A6XX_RBBM_CLOCK_DELAY_TP0, 0x11111111 },
	{ REG_A6XX_RBBM_CLOCK_DELAY2_TP0, 0x11111111 },
	{ REG_A6XX_RBBM_CLOCK_DELAY3_TP0, 0x11111111 },
	{ REG_A6XX_RBBM_CLOCK_DELAY4_TP0, 0x00011111 },
	{ REG_A6XX_RBBM_CLOCK_CNTL_UCHE, 0x22222222 },
	{ REG_A6XX_RBBM_CLOCK_CNTL2_UCHE, 0x00222222 },
	{ REG_A6XX_RBBM_CLOCK_HYST_UCHE, 0x00000444 },
	{ REG_A6XX_RBBM_CLOCK_DELAY_UCHE, 0x00000222 },
	{ REG_A6XX_RBBM_CLOCK_CNTL_RB0, 0x22222222 },
	{ REG_A6XX_RBBM_CLOCK_CNTL2_RB0, 0x01002222 },
	{ REG_A6XX_RBBM_CLOCK_CNTL_CCU0, 0x00002220 },
	{ REG_A6XX_RBBM_CLOCK_HYST_RB_CCU0, 0x44000f00 },
	{ REG_A6XX_RBBM_CLOCK_CNTL_RAC, 0x25222022 },
	{ REG_A6XX_RBBM_CLOCK_CNTL2_RAC, 0x00555555 },
	{ REG_A6XX_RBBM_CLOCK_DELAY_RAC, 0x00000011 },
	{ REG_A6XX_RBBM_CLOCK_HYST_RAC, 0x00440044 },
	{ REG_A6XX_RBBM_CLOCK_CNTL_TSE_RAS_RBBM, 0x04222222 },
	{ REG_A7XX_RBBM_CLOCK_MODE2_GRAS, 0x00000222 },
	{ REG_A7XX_RBBM_CLOCK_MODE_BV_GRAS, 0x00222222 },
	{ REG_A6XX_RBBM_CLOCK_MODE_GPC, 0x02222223 },
	{ REG_A6XX_RBBM_CLOCK_MODE_VFD, 0x00222222 },
	{ REG_A7XX_RBBM_CLOCK_MODE_BV_GPC, 0x00222222 },
	{ REG_A7XX_RBBM_CLOCK_MODE_BV_VFD, 0x00002222 },
	{ REG_A6XX_RBBM_CLOCK_HYST_TSE_RAS_RBBM, 0x00000000 },
	{ REG_A6XX_RBBM_CLOCK_HYST_GPC, 0x04104004 },
	{ REG_A6XX_RBBM_CLOCK_HYST_VFD, 0x00000000 },
	{ REG_A6XX_RBBM_CLOCK_DELAY_TSE_RAS_RBBM, 0x00000000 },
	{ REG_A6XX_RBBM_CLOCK_DELAY_GPC, 0x00000200 },
	{ REG_A6XX_RBBM_CLOCK_DELAY_VFD, 0x00000000 },
	{ REG_A6XX_RBBM_CLOCK_MODE_HLSQ, 0x00002222 },
	{ REG_A6XX_RBBM_CLOCK_DELAY_HLSQ, 0x00000000 },
	{ REG_A6XX_RBBM_CLOCK_HYST_HLSQ, 0x00000000 },
	{ REG_A7XX_RBBM_CLOCK_MODE_BV_LRZ, 0x55555552 },
	{ REG_A7XX_RBBM_CLOCK_HYST2_VFD, 0x00000000 },
	{ REG_A7XX_RBBM_CLOCK_MODE_CP, 0x00000222 },
	{ REG_A6XX_RBBM_CLOCK_CNTL, 0x8aa8aa82 },
	{ REG_A6XX_RBBM_ISDB_CNT, 0x00000182 },
	{ REG_A6XX_RBBM_RAC_THRESHOLD_CNT, 0x00000000 },
	{ REG_A6XX_RBBM_SP_HYST_CNT, 0x00000000 },
	{ REG_A6XX_RBBM_CLOCK_CNTL_GMU_GX, 0x00000222 },
	{ REG_A6XX_RBBM_CLOCK_DELAY_GMU_GX, 0x00000111 },
	{ REG_A6XX_RBBM_CLOCK_HYST_GMU_GX, 0x00000555 },
	{},
};

static const u32 a730_protect_regs[] = {
	A6XX_PROTECT_RDONLY(0x00000, 0x04ff),
	A6XX_PROTECT_RDONLY(0x0050b, 0x0058),
	A6XX_PROTECT_NORDWR(0x0050e, 0x0000),
	A6XX_PROTECT_NORDWR(0x00510, 0x0000),
	A6XX_PROTECT_NORDWR(0x00534, 0x0000),
	A6XX_PROTECT_RDONLY(0x005fb, 0x009d),
	A6XX_PROTECT_NORDWR(0x00699, 0x01e9),
	A6XX_PROTECT_NORDWR(0x008a0, 0x0008),
	A6XX_PROTECT_NORDWR(0x008ab, 0x0024),
	/* 0x008d0-0x008dd and 0x008e0-0x008e6 are unprotected on purpose for tools like perfetto */
	A6XX_PROTECT_NORDWR(0x008de, 0x0001),
	A6XX_PROTECT_RDONLY(0x008e7, 0x014b),
	A6XX_PROTECT_NORDWR(0x00900, 0x004d),
	A6XX_PROTECT_NORDWR(0x0098d, 0x00b2),
	A6XX_PROTECT_NORDWR(0x00a41, 0x01be),
	A6XX_PROTECT_NORDWR(0x00df0, 0x0001),
	A6XX_PROTECT_NORDWR(0x00e01, 0x0000),
	A6XX_PROTECT_NORDWR(0x00e07, 0x0008),
	A6XX_PROTECT_NORDWR(0x03c00, 0x00c3),
	A6XX_PROTECT_RDONLY(0x03cc4, 0x1fff),
	A6XX_PROTECT_NORDWR(0x08630, 0x01cf),
	A6XX_PROTECT_NORDWR(0x08e00, 0x0000),
	A6XX_PROTECT_NORDWR(0x08e08, 0x0000),
	A6XX_PROTECT_NORDWR(0x08e50, 0x001f),
	A6XX_PROTECT_NORDWR(0x08e80, 0x0280),
	A6XX_PROTECT_NORDWR(0x09624, 0x01db),
	A6XX_PROTECT_NORDWR(0x09e40, 0x0000),
	A6XX_PROTECT_NORDWR(0x09e64, 0x000d),
	A6XX_PROTECT_NORDWR(0x09e78, 0x0187),
	A6XX_PROTECT_NORDWR(0x0a630, 0x01cf),
	A6XX_PROTECT_NORDWR(0x0ae02, 0x0000),
	A6XX_PROTECT_NORDWR(0x0ae50, 0x000f),
	A6XX_PROTECT_NORDWR(0x0ae66, 0x0003),
	A6XX_PROTECT_NORDWR(0x0ae6f, 0x0003),
	A6XX_PROTECT_NORDWR(0x0b604, 0x0003),
	A6XX_PROTECT_NORDWR(0x0ec00, 0x0fff),
	A6XX_PROTECT_RDONLY(0x0fc00, 0x1fff),
	A6XX_PROTECT_NORDWR(0x18400, 0x0053),
	A6XX_PROTECT_RDONLY(0x18454, 0x0004),
	A6XX_PROTECT_NORDWR(0x18459, 0x1fff),
	A6XX_PROTECT_NORDWR(0x1a459, 0x1fff),
	A6XX_PROTECT_NORDWR(0x1c459, 0x1fff),
	A6XX_PROTECT_NORDWR(0x1f400, 0x0443),
	A6XX_PROTECT_RDONLY(0x1f844, 0x007b),
	A6XX_PROTECT_NORDWR(0x1f860, 0x0000),
	A6XX_PROTECT_NORDWR(0x1f878, 0x002a),
	/* CP_PROTECT_REG[45, 46] are left untouched! */
	0,
	0,
	A6XX_PROTECT_NORDWR(0x1f8c0, 0x00000),
};
DECLARE_ADRENO_PROTECT(a730_protect, 48);

static const uint32_t a7xx_pwrup_reglist_regs[] = {
	REG_A6XX_UCHE_TRAP_BASE,
	REG_A6XX_UCHE_TRAP_BASE + 1,
	REG_A6XX_UCHE_WRITE_THRU_BASE,
	REG_A6XX_UCHE_WRITE_THRU_BASE + 1,
	REG_A6XX_UCHE_GMEM_RANGE_MIN,
	REG_A6XX_UCHE_GMEM_RANGE_MIN + 1,
	REG_A6XX_UCHE_GMEM_RANGE_MAX,
	REG_A6XX_UCHE_GMEM_RANGE_MAX + 1,
	REG_A6XX_UCHE_CACHE_WAYS,
	REG_A6XX_UCHE_MODE_CNTL,
	REG_A6XX_RB_NC_MODE_CNTL,
	REG_A6XX_RB_CMP_DBG_ECO_CNTL,
	REG_A6XX_RB_CONTEXT_SWITCH_GMEM_SAVE_RESTORE_ENABLE,
	REG_A6XX_UCHE_GBIF_GX_CONFIG,
	REG_A6XX_UCHE_CLIENT_PF,
	REG_A6XX_TPL1_DBG_ECO_CNTL1,
};

DECLARE_ADRENO_REGLIST_LIST(a7xx_pwrup_reglist);

/* Applicable for X185, A750 */
static const u32 a750_ifpc_reglist_regs[] = {
	REG_A6XX_TPL1_BICUBIC_WEIGHTS_TABLE(0),
	REG_A6XX_TPL1_BICUBIC_WEIGHTS_TABLE(1),
	REG_A6XX_TPL1_BICUBIC_WEIGHTS_TABLE(2),
	REG_A6XX_TPL1_BICUBIC_WEIGHTS_TABLE(3),
	REG_A6XX_TPL1_BICUBIC_WEIGHTS_TABLE(4),
	REG_A6XX_RBBM_PERFCTR_CNTL,
	REG_A6XX_TPL1_NC_MODE_CNTL,
	REG_A6XX_SP_NC_MODE_CNTL,
	REG_A6XX_CP_DBG_ECO_CNTL,
	REG_A6XX_CP_PROTECT_CNTL,
	REG_A6XX_CP_PROTECT(0),
	REG_A6XX_CP_PROTECT(1),
	REG_A6XX_CP_PROTECT(2),
	REG_A6XX_CP_PROTECT(3),
	REG_A6XX_CP_PROTECT(4),
	REG_A6XX_CP_PROTECT(5),
	REG_A6XX_CP_PROTECT(6),
	REG_A6XX_CP_PROTECT(7),
	REG_A6XX_CP_PROTECT(8),
	REG_A6XX_CP_PROTECT(9),
	REG_A6XX_CP_PROTECT(10),
	REG_A6XX_CP_PROTECT(11),
	REG_A6XX_CP_PROTECT(12),
	REG_A6XX_CP_PROTECT(13),
	REG_A6XX_CP_PROTECT(14),
	REG_A6XX_CP_PROTECT(15),
	REG_A6XX_CP_PROTECT(16),
	REG_A6XX_CP_PROTECT(17),
	REG_A6XX_CP_PROTECT(18),
	REG_A6XX_CP_PROTECT(19),
	REG_A6XX_CP_PROTECT(20),
	REG_A6XX_CP_PROTECT(21),
	REG_A6XX_CP_PROTECT(22),
	REG_A6XX_CP_PROTECT(23),
	REG_A6XX_CP_PROTECT(24),
	REG_A6XX_CP_PROTECT(25),
	REG_A6XX_CP_PROTECT(26),
	REG_A6XX_CP_PROTECT(27),
	REG_A6XX_CP_PROTECT(28),
	REG_A6XX_CP_PROTECT(29),
	REG_A6XX_CP_PROTECT(30),
	REG_A6XX_CP_PROTECT(31),
	REG_A6XX_CP_PROTECT(32),
	REG_A6XX_CP_PROTECT(33),
	REG_A6XX_CP_PROTECT(34),
	REG_A6XX_CP_PROTECT(35),
	REG_A6XX_CP_PROTECT(36),
	REG_A6XX_CP_PROTECT(37),
	REG_A6XX_CP_PROTECT(38),
	REG_A6XX_CP_PROTECT(39),
	REG_A6XX_CP_PROTECT(40),
	REG_A6XX_CP_PROTECT(41),
	REG_A6XX_CP_PROTECT(42),
	REG_A6XX_CP_PROTECT(43),
	REG_A6XX_CP_PROTECT(44),
	REG_A6XX_CP_PROTECT(45),
	REG_A6XX_CP_PROTECT(46),
	REG_A6XX_CP_PROTECT(47),
};

DECLARE_ADRENO_REGLIST_LIST(a750_ifpc_reglist);

static const struct adreno_reglist_pipe a7xx_dyn_pwrup_reglist_regs[] = {
	{ REG_A7XX_GRAS_NC_MODE_CNTL, 0, BIT(PIPE_BV) | BIT(PIPE_BR) },
};

DECLARE_ADRENO_REGLIST_PIPE_LIST(a7xx_dyn_pwrup_reglist);

static const struct adreno_info a7xx_gpus[] = {
	{
		.chip_ids = ADRENO_CHIP_IDS(0x07000200),
		.family = ADRENO_6XX_GEN1, /* NOT a mistake! */
		.fw = {
			[ADRENO_FW_SQE] = "/*(DEBLOBBED)*/",
		},
		.gmem = SZ_128K,
		.inactive_period = DRM_MSM_INACTIVE_PERIOD,
		.quirks = ADRENO_QUIRK_HAS_HW_APRIV,
		.funcs = &a6xx_gmuwrapper_funcs,
		.zapfw = "/*(DEBLOBBED)*/",
		.a6xx = &(const struct a6xx_info) {
			.hwcg = a702_hwcg,
			.protect = &a650_protect,
			.gbif_cx = a640_gbif,
			.gmu_cgc_mode = 0x00020202,
			.prim_fifo_threshold = 0x0000c000,
		},
		.speedbins = ADRENO_SPEEDBINS(
			{ 0,   0 },
			{ 236, 1 },
			{ 178, 2 },
			{ 142, 3 },
		),
	}, {
		.chip_ids = ADRENO_CHIP_IDS(0x07030001),
		.family = ADRENO_7XX_GEN1,
		.fw = {
			[ADRENO_FW_SQE] = "/*(DEBLOBBED)*/",
			[ADRENO_FW_GMU] = "/*(DEBLOBBED)*/",
		},
		.gmem = SZ_2M,
		.inactive_period = DRM_MSM_INACTIVE_PERIOD,
		.quirks = ADRENO_QUIRK_HAS_CACHED_COHERENT |
			  ADRENO_QUIRK_HAS_HW_APRIV |
			  ADRENO_QUIRK_PREEMPTION,
		.funcs = &a7xx_gpu_funcs,
		.zapfw = "/*(DEBLOBBED)*/",
		.a6xx = &(const struct a6xx_info) {
			.hwcg = a730_hwcg,
			.protect = &a730_protect,
			.pwrup_reglist = &a7xx_pwrup_reglist,
			.dyn_pwrup_reglist = &a7xx_dyn_pwrup_reglist,
			.gbif_cx = a640_gbif,
			.gmu_cgc_mode = 0x00020000,
		},
		.preempt_record_size = 2860 * SZ_1K,
	}, {
		.chip_ids = ADRENO_CHIP_IDS(0x43050a01), /* "C510v2" */
		.family = ADRENO_7XX_GEN2,
		.fw = {
			[ADRENO_FW_SQE] = "/*(DEBLOBBED)*/",
			[ADRENO_FW_GMU] = "/*(DEBLOBBED)*/",
		},
		.gmem = 3 * SZ_1M,
		.inactive_period = DRM_MSM_INACTIVE_PERIOD,
		.quirks = ADRENO_QUIRK_HAS_CACHED_COHERENT |
			  ADRENO_QUIRK_HAS_HW_APRIV |
			  ADRENO_QUIRK_PREEMPTION,
		.funcs = &a7xx_gpu_funcs,
		.zapfw = "/*(DEBLOBBED)*/",
		.a6xx = &(const struct a6xx_info) {
			.hwcg = a740_hwcg,
			.protect = &a730_protect,
			.pwrup_reglist = &a7xx_pwrup_reglist,
			.dyn_pwrup_reglist = &a7xx_dyn_pwrup_reglist,
			.gbif_cx = a640_gbif,
			.gmu_chipid = 0x7020100,
			.gmu_cgc_mode = 0x00020202,
			.bcms = (const struct a6xx_bcm[]) {
				{ .name = "SH0", .buswidth = 16 },
				{ .name = "MC0", .buswidth = 4 },
				{
					.name = "ACV",
					.fixed = true,
					.perfmode = BIT(3),
					.perfmode_bw = 16500000,
				},
				{ /* sentinel */ },
			},
		},
		.preempt_record_size = 4192 * SZ_1K,
	}, {
		.chip_ids = ADRENO_CHIP_IDS(0x43050c01), /* "C512v2" */
		.family = ADRENO_7XX_GEN2,
		.fw = {
			[ADRENO_FW_SQE] = "/*(DEBLOBBED)*/",
			[ADRENO_FW_GMU] = "/*(DEBLOBBED)*/",
		},
		.gmem = 3 * SZ_1M,
		.inactive_period = DRM_MSM_INACTIVE_PERIOD,
		.quirks = ADRENO_QUIRK_HAS_CACHED_COHERENT |
			  ADRENO_QUIRK_HAS_HW_APRIV |
			  ADRENO_QUIRK_PREEMPTION |
			  ADRENO_QUIRK_IFPC,
		.funcs = &a7xx_gpu_funcs,
		.a6xx = &(const struct a6xx_info) {
			.hwcg = a740_hwcg,
			.protect = &a730_protect,
			.pwrup_reglist = &a7xx_pwrup_reglist,
			.dyn_pwrup_reglist = &a7xx_dyn_pwrup_reglist,
			.ifpc_reglist = &a750_ifpc_reglist,
			.gbif_cx = a640_gbif,
			.gmu_chipid = 0x7050001,
			.gmu_cgc_mode = 0x00020202,
			.bcms = (const struct a6xx_bcm[]) {
				{ .name = "SH0", .buswidth = 16 },
				{ .name = "MC0", .buswidth = 4 },
				{
					.name = "ACV",
					.fixed = true,
					.perfmode = BIT(3),
					.perfmode_bw = 16500000,
				},
				{ /* sentinel */ },
			},
		},
		.preempt_record_size = 4192 * SZ_1K,
		.speedbins = ADRENO_SPEEDBINS(
			{ 0,	0 },
			{ 59,	1 },
			{ 7,	2 },
			{ 232,	3 },
			{ 146,	4 },
		),
	}, {
		.chip_ids = ADRENO_CHIP_IDS(0x43051401), /* "C520v2" */
		.family = ADRENO_7XX_GEN3,
		.fw = {
			[ADRENO_FW_SQE] = "/*(DEBLOBBED)*/",
			[ADRENO_FW_GMU] = "/*(DEBLOBBED)*/",
		},
		.gmem = 3 * SZ_1M,
		.inactive_period = DRM_MSM_INACTIVE_PERIOD,
		.quirks = ADRENO_QUIRK_HAS_CACHED_COHERENT |
			  ADRENO_QUIRK_HAS_HW_APRIV |
			  ADRENO_QUIRK_PREEMPTION |
			  ADRENO_QUIRK_IFPC,
		.funcs = &a7xx_gpu_funcs,
		.zapfw = "/*(DEBLOBBED)*/",
		.a6xx = &(const struct a6xx_info) {
			.protect = &a730_protect,
			.pwrup_reglist = &a7xx_pwrup_reglist,
			.dyn_pwrup_reglist = &a7xx_dyn_pwrup_reglist,
			.ifpc_reglist = &a750_ifpc_reglist,
			.gbif_cx = a640_gbif,
			.gmu_chipid = 0x7090100,
			.gmu_cgc_mode = 0x00020202,
			.bcms = (const struct a6xx_bcm[]) {
				{ .name = "SH0", .buswidth = 16 },
				{ .name = "MC0", .buswidth = 4 },
				{
					.name = "ACV",
					.fixed = true,
					.perfmode = BIT(2),
					.perfmode_bw = 10687500,
				},
				{ /* sentinel */ },
			},
		},
		.preempt_record_size = 3572 * SZ_1K,
	}, {
		.chip_ids = ADRENO_CHIP_IDS(0x43030c00),
		.family = ADRENO_7XX_GEN2,
		.fw = {
			[ADRENO_FW_SQE] = "/*(DEBLOBBED)*/",
			[ADRENO_FW_GMU] = "/*(DEBLOBBED)*/",
		},
		.gmem = SZ_1M + SZ_512K,
		.inactive_period = DRM_MSM_INACTIVE_PERIOD,
		.quirks = ADRENO_QUIRK_HAS_CACHED_COHERENT |
			  ADRENO_QUIRK_HAS_HW_APRIV |
			  ADRENO_QUIRK_PREEMPTION,
		.funcs = &a7xx_gpu_funcs,
		.a6xx = &(const struct a6xx_info) {
			.hwcg = a740_hwcg,
			.protect = &a730_protect,
			.pwrup_reglist = &a7xx_pwrup_reglist,
			.dyn_pwrup_reglist = &a7xx_dyn_pwrup_reglist,
			.gbif_cx = a640_gbif,
			.gmu_chipid = 0x70f0000,
			.gmu_cgc_mode = 0x00020222,
			.bcms = (const struct a6xx_bcm[]) {
				{ .name = "SH0", .buswidth = 16 },
				{ .name = "MC0", .buswidth = 4 },
				{
					.name = "ACV",
					.fixed = true,
					.perfmode = BIT(3),
					.perfmode_bw = 16500000,
				},
				{ /* sentinel */ },
			},
		},
		.preempt_record_size = 4192 * SZ_1K,
		.speedbins = ADRENO_SPEEDBINS(
			{ 0,   0 },
			{ 294, 1 },
			{ 263, 2 },
			{ 233, 3 },
			{ 141, 4 },
		),
	}
};
DECLARE_ADRENO_GPULIST(a7xx);

static const struct adreno_reglist_pipe x285_nonctxt_regs[] = {
	{ REG_A8XX_CP_SMMU_STREAM_ID_LPAC, 0x00000101, BIT(PIPE_NONE) },
	{ REG_A8XX_GRAS_DBG_ECO_CNTL, 0x00000800, BIT(PIPE_BV) | BIT(PIPE_BR) },
	{ REG_A8XX_GRAS_TSEFE_DBG_ECO_CNTL, 0x00200000, BIT(PIPE_BV) | BIT(PIPE_BR) },
	{ REG_A6XX_PC_AUTO_VERTEX_STRIDE, 0x00000001, BIT(PIPE_BV) | BIT(PIPE_BR) },
	{ REG_A8XX_PC_VIS_STREAM_CNTL, 0x10010000, BIT(PIPE_BV) | BIT(PIPE_BR) },
	{ REG_A8XX_PC_CONTEXT_SWITCH_STABILIZE_CNTL_1, 0x00000002, BIT(PIPE_BV) | BIT(PIPE_BR) },
	{ REG_A8XX_PC_CHICKEN_BITS_1, 0x00000003, BIT(PIPE_BV) | BIT(PIPE_BR) },
	{ REG_A8XX_PC_CHICKEN_BITS_2, 0x00000200, BIT(PIPE_BV) | BIT(PIPE_BR) },
	{ REG_A8XX_PC_CHICKEN_BITS_3, 0x00500000, BIT(PIPE_BV) | BIT(PIPE_BR) },
	{ REG_A8XX_PC_CHICKEN_BITS_4, 0x00500050, BIT(PIPE_BV) | BIT(PIPE_BR) },
	{ REG_A8XX_RB_GC_GMEM_PROTECT, 0x15000000, BIT(PIPE_BR) },
	{ REG_A8XX_RB_RESOLVE_PREFETCH_CNTL, 0x00000007, BIT(PIPE_BR) },
	{ REG_A8XX_RB_CMP_DBG_ECO_CNTL, 0x00004000, BIT(PIPE_BR) },
	{ REG_A8XX_RBBM_NC_MODE_CNTL, 0x00000001, BIT(PIPE_NONE) },
	{ REG_A8XX_RBBM_SLICE_NC_MODE_CNTL, 0x00000001, BIT(PIPE_NONE) },
	{ REG_A8XX_RBBM_WAIT_IDLE_CLOCKS_CNTL, 0x00000030, BIT(PIPE_NONE) },
	{ REG_A8XX_RBBM_WAIT_IDLE_CLOCKS_CNTL2, 0x00000030, BIT(PIPE_NONE) },
	{ REG_A8XX_RBBM_INTERFACE_HANG_INT_CNTL, 0x0fffffff, BIT(PIPE_NONE) },
	{ REG_A8XX_RBBM_GBIF_CLIENT_QOS_CNTL, 0x22122212, BIT(PIPE_NONE) },
	{ REG_A8XX_RBBM_CGC_P2S_CNTL, 0x00000040, BIT(PIPE_NONE) },
	{ REG_A7XX_SP_CHICKEN_BITS_2, 0x00820800, BIT(PIPE_NONE) },
	{ REG_A7XX_SP_CHICKEN_BITS_3, 0x00300000, BIT(PIPE_NONE) },
	{ REG_A6XX_SP_PERFCTR_SHADER_MASK, 0x0000003f, BIT(PIPE_NONE) },
	/* Disable CS dead batch merge */
	{ REG_A7XX_SP_HLSQ_DBG_ECO_CNTL_2, BIT(31), BIT(PIPE_NONE) },
	{ REG_A7XX_SP_HLSQ_TIMEOUT_THRESHOLD_DP, 0x00000080, BIT(PIPE_NONE) },
	{ REG_A7XX_SP_READ_SEL, 0x0001ff00, BIT(PIPE_NONE) },
	{ REG_A6XX_TPL1_DBG_ECO_CNTL, 0x10000000, BIT(PIPE_NONE) },
	/* BIT(26): Disable final clamp for bicubic filtering */
	{ REG_A6XX_TPL1_DBG_ECO_CNTL1, 0x04000720, BIT(PIPE_NONE) },
	{ REG_A6XX_UCHE_MODE_CNTL, 0x80080000, BIT(PIPE_NONE) },
	{ REG_A8XX_UCHE_CCHE_MODE_CNTL, 0x00001000, BIT(PIPE_NONE) },
	{ REG_A8XX_UCHE_CCHE_CACHE_WAYS, 0x00000800, BIT(PIPE_NONE) },
	{ REG_A8XX_UCHE_GBIF_GX_CONFIG, 0x010240e0, BIT(PIPE_NONE) },
	{ REG_A8XX_UCHE_VARB_IDLE_TIMEOUT, 0x00000020, BIT(PIPE_NONE) },
	{ REG_A7XX_VFD_DBG_ECO_CNTL, 0x00008000, BIT(PIPE_BV) | BIT(PIPE_BR) },
	{ REG_A8XX_VFD_CB_BV_THRESHOLD, 0x00500050, BIT(PIPE_BV) | BIT(PIPE_BR) },
	{ REG_A8XX_VFD_CB_BR_THRESHOLD, 0x00600060, BIT(PIPE_BV) | BIT(PIPE_BR) },
	{ REG_A8XX_VFD_CB_BUSY_REQ_CNT, 0x00200020, BIT(PIPE_BV) | BIT(PIPE_BR) },
	{ REG_A8XX_VFD_CB_LP_REQ_CNT, 0x00000020, BIT(PIPE_BV) | BIT(PIPE_BR) },
	{ REG_A8XX_VPC_FLATSHADE_MODE_CNTL, 0x00000001, BIT(PIPE_BV) | BIT(PIPE_BR) },
	{ },
};

static const u32 x285_protect_regs[] = {
	A6XX_PROTECT_RDONLY(0x00008, 0x039b),
	A6XX_PROTECT_RDONLY(0x003b4, 0x008b),
	A6XX_PROTECT_NORDWR(0x00440, 0x001f),
	A6XX_PROTECT_RDONLY(0x00580, 0x005f),
	A6XX_PROTECT_NORDWR(0x005e0, 0x011f),
	A6XX_PROTECT_RDONLY(0x0074a, 0x0005),
	A6XX_PROTECT_RDONLY(0x00759, 0x0026),
	A6XX_PROTECT_RDONLY(0x00789, 0x0000),
	A6XX_PROTECT_RDONLY(0x0078c, 0x0013),
	A6XX_PROTECT_NORDWR(0x00800, 0x0029),
	A6XX_PROTECT_NORDWR(0x0082c, 0x0000),
	A6XX_PROTECT_NORDWR(0x00837, 0x00af),
	A6XX_PROTECT_RDONLY(0x008e7, 0x00c9),
	A6XX_PROTECT_NORDWR(0x008ec, 0x00c3),
	A6XX_PROTECT_NORDWR(0x009b1, 0x0250),
	A6XX_PROTECT_RDONLY(0x00ce0, 0x0001),
	A6XX_PROTECT_RDONLY(0x00df0, 0x0000),
	A6XX_PROTECT_NORDWR(0x00df1, 0x0000),
	A6XX_PROTECT_NORDWR(0x00e01, 0x0000),
	A6XX_PROTECT_NORDWR(0x00e03, 0x1fff),
	A6XX_PROTECT_NORDWR(0x03c00, 0x00c5),
	A6XX_PROTECT_RDONLY(0x03cc6, 0x0039),
	A6XX_PROTECT_NORDWR(0x03d00, 0x1fff),
	A6XX_PROTECT_NORDWR(0x08600, 0x01ff),
	A6XX_PROTECT_NORDWR(0x08e00, 0x00ff),
	A6XX_PROTECT_RDONLY(0x08f00, 0x0000),
	A6XX_PROTECT_NORDWR(0x08f01, 0x01be),
	A6XX_PROTECT_NORDWR(0x09600, 0x01ff),
	A6XX_PROTECT_RDONLY(0x0981a, 0x02e5),
	A6XX_PROTECT_NORDWR(0x09e00, 0x01ff),
	A6XX_PROTECT_NORDWR(0x0a600, 0x01ff),
	A6XX_PROTECT_NORDWR(0x0a82e, 0x0000),
	A6XX_PROTECT_NORDWR(0x0ae00, 0x0006),
	A6XX_PROTECT_NORDWR(0x0ae08, 0x0006),
	A6XX_PROTECT_NORDWR(0x0ae10, 0x00bf),
	A6XX_PROTECT_RDONLY(0x0aed0, 0x002f),
	A6XX_PROTECT_NORDWR(0x0af00, 0x027f),
	A6XX_PROTECT_NORDWR(0x0b600, 0x1fff),
	A6XX_PROTECT_NORDWR(0x0dc00, 0x1fff),
	A6XX_PROTECT_RDONLY(0x0fc00, 0x1fff),
	A6XX_PROTECT_NORDWR(0x18400, 0x003f),
	A6XX_PROTECT_RDONLY(0x18440, 0x013f),
	A6XX_PROTECT_NORDWR(0x18580, 0x1fff),
	A6XX_PROTECT_NORDWR(0x1b400, 0x1fff),
	A6XX_PROTECT_NORDWR(0x1f400, 0x0477),
	A6XX_PROTECT_RDONLY(0x1f878, 0x0507),
	A6XX_PROTECT_NORDWR(0x1f930, 0x0329),
	A6XX_PROTECT_NORDWR(0x1fd80, 0x1fff),
	A6XX_PROTECT_NORDWR(0x27800, 0x007f),
	A6XX_PROTECT_RDONLY(0x27880, 0x0385),
	A6XX_PROTECT_NORDWR(0x27882, 0x000a),
	A6XX_PROTECT_NORDWR(0x27c06, 0x0000),
};

DECLARE_ADRENO_PROTECT(x285_protect, 64);

static const struct adreno_reglist_pipe a840_nonctxt_regs[] = {
	{ REG_A8XX_CP_SMMU_STREAM_ID_LPAC, 0x00000101, BIT(PIPE_NONE) },
	{ REG_A8XX_GRAS_DBG_ECO_CNTL, 0x00000800, BIT(PIPE_BV) | BIT(PIPE_BR) },
	{ REG_A8XX_GRAS_TSEFE_DBG_ECO_CNTL, 0x00200000, BIT(PIPE_BV) | BIT(PIPE_BR) },
	{ REG_A6XX_PC_AUTO_VERTEX_STRIDE, 0x00000001, BIT(PIPE_BV) | BIT(PIPE_BR) },
	{ REG_A8XX_PC_VIS_STREAM_CNTL, 0x10010000, BIT(PIPE_BV) | BIT(PIPE_BR) },
	{ REG_A8XX_PC_CONTEXT_SWITCH_STABILIZE_CNTL_1, 0x00000002, BIT(PIPE_BV) | BIT(PIPE_BR) },
	{ REG_A8XX_PC_CHICKEN_BITS_1, 0x00000003, BIT(PIPE_BV) | BIT(PIPE_BR) },
	{ REG_A8XX_PC_CHICKEN_BITS_2, 0x00000200, BIT(PIPE_BV) | BIT(PIPE_BR) },
	{ REG_A8XX_PC_CHICKEN_BITS_3, 0x00500000, BIT(PIPE_BV) | BIT(PIPE_BR) },
	{ REG_A8XX_PC_CHICKEN_BITS_4, 0x00500050, BIT(PIPE_BV) | BIT(PIPE_BR) },
	/* Disable Dead Draw Merge scheme on RB-HLSQ */
	{ REG_A6XX_RB_RBP_CNTL, BIT(5), BIT(PIPE_BV) | BIT(PIPE_BR) },
	{ REG_A7XX_RB_CCU_CNTL, 0x00000068, BIT(PIPE_BR) },
	/* Partially enable perf clear, Disable DINT to c/z be data forwarding */
	{ REG_A7XX_RB_CCU_DBG_ECO_CNTL, 0x00002200, BIT(PIPE_BR) },
	{ REG_A8XX_RB_GC_GMEM_PROTECT, 0x12000000, BIT(PIPE_BR) },
	{ REG_A8XX_RB_RESOLVE_PREFETCH_CNTL, 0x00000007, BIT(PIPE_BR) },
	{ REG_A8XX_RB_CMP_DBG_ECO_CNTL, 0x00004000, BIT(PIPE_BR) },
	{ REG_A8XX_RBBM_NC_MODE_CNTL, 0x00000001, BIT(PIPE_NONE) },
	{ REG_A8XX_RBBM_SLICE_NC_MODE_CNTL, 0x00000001, BIT(PIPE_NONE) },
	{ REG_A8XX_RBBM_POWER_UP_RESET_SW_OVERRIDE, 0x70809060, BIT(PIPE_NONE) },
	{ REG_A8XX_RBBM_POWER_UP_RESET_SW_BV_OVERRIDE, 0x30000000, BIT(PIPE_NONE) },
	{ REG_A8XX_RBBM_WAIT_IDLE_CLOCKS_CNTL, 0x00000030, BIT(PIPE_NONE) },
	{ REG_A8XX_RBBM_WAIT_IDLE_CLOCKS_CNTL2, 0x00000030, BIT(PIPE_NONE) },
	{ REG_A8XX_RBBM_INTERFACE_HANG_INT_CNTL, 0x0fffffff, BIT(PIPE_NONE) },
	{ REG_A8XX_RBBM_GBIF_CLIENT_QOS_CNTL, 0x22122212, BIT(PIPE_NONE) },
	{ REG_A8XX_RBBM_CGC_P2S_CNTL, 0x00000040, BIT(PIPE_NONE) },
	/* Disable mode_switch optimization in UMAS */
	{ REG_A6XX_SP_CHICKEN_BITS, BIT(24) | BIT(26), BIT(PIPE_NONE) },
	/* Disable LPAC large-LM mode */
	{ REG_A8XX_SP_SS_CHICKEN_BITS_0, BIT(3), BIT(PIPE_NONE) },
	/* Disable PS out of order retire */
	{ REG_A7XX_SP_CHICKEN_BITS_2, 0x00c21800, BIT(PIPE_NONE) },
	{ REG_A7XX_SP_CHICKEN_BITS_3, 0x00300000, BIT(PIPE_NONE) },
	/* Disable SP2TP info attribute */
	{ REG_A8XX_SP_CHICKEN_BITS_4, 0x00000002, BIT(PIPE_NONE) },
	{ REG_A6XX_SP_PERFCTR_SHADER_MASK, 0x0000003f, BIT(PIPE_NONE) },
	{ REG_A7XX_SP_HLSQ_DBG_ECO_CNTL, BIT(14), BIT(PIPE_NONE) },
	/* Ignore HLSQ shared constant feedback from SP */
	{ REG_A7XX_SP_HLSQ_DBG_ECO_CNTL_1, BIT(17), BIT(PIPE_NONE) },
	/* Disable CS dead batch merge */
	{ REG_A7XX_SP_HLSQ_DBG_ECO_CNTL_2, BIT(24), BIT(PIPE_NONE) },
	{ REG_A8XX_SP_HLSQ_DBG_ECO_CNTL_3, BIT(7), BIT(PIPE_NONE) },
	{ REG_A7XX_SP_HLSQ_TIMEOUT_THRESHOLD_DP, 0x00000080, BIT(PIPE_NONE) },
	{ REG_A7XX_SP_READ_SEL, 0x0001ff00, BIT(PIPE_NONE) },
	{ REG_A6XX_TPL1_DBG_ECO_CNTL, 0x10100000, BIT(PIPE_NONE) },
	/* BIT(26): Disable final clamp for bicubic filtering */
	{ REG_A6XX_TPL1_DBG_ECO_CNTL1, 0x04000720, BIT(PIPE_NONE) },
	{ REG_A6XX_UCHE_MODE_CNTL, 0x80080000, BIT(PIPE_NONE) },
	{ REG_A8XX_UCHE_CCHE_MODE_CNTL, 0x00001000, BIT(PIPE_NONE) },
	{ REG_A8XX_UCHE_CCHE_CACHE_WAYS, 0x00000800, BIT(PIPE_NONE) },
	{ REG_A8XX_UCHE_GBIF_GX_CONFIG, 0x010240e0, BIT(PIPE_NONE) },
	{ REG_A8XX_UCHE_VARB_IDLE_TIMEOUT, 0x00000020, BIT(PIPE_NONE) },
	{ REG_A7XX_VFD_DBG_ECO_CNTL, 0x00008000, BIT(PIPE_BV) | BIT(PIPE_BR) },
	{ REG_A8XX_VFD_CB_BV_THRESHOLD, 0x00500050, BIT(PIPE_BV) | BIT(PIPE_BR) },
	{ REG_A8XX_VFD_CB_BR_THRESHOLD, 0x00600060, BIT(PIPE_BV) | BIT(PIPE_BR) },
	{ REG_A8XX_VFD_CB_BUSY_REQ_CNT, 0x00200020, BIT(PIPE_BV) | BIT(PIPE_BR) },
	{ REG_A8XX_VFD_CB_LP_REQ_CNT, 0x00000020, BIT(PIPE_BV) | BIT(PIPE_BR) },
	{ REG_A8XX_VPC_FLATSHADE_MODE_CNTL, 0x00000001, BIT(PIPE_BV) | BIT(PIPE_BR) },
	{ },
};

static const u32 a840_protect_regs[] = {
	A6XX_PROTECT_RDONLY(0x00008, 0x039b),
	A6XX_PROTECT_RDONLY(0x003b4, 0x008b),
	A6XX_PROTECT_NORDWR(0x00440, 0x001f),
	A6XX_PROTECT_RDONLY(0x00580, 0x005f),
	A6XX_PROTECT_NORDWR(0x005e0, 0x011f),
	A6XX_PROTECT_RDONLY(0x0074a, 0x0005),
	A6XX_PROTECT_RDONLY(0x00759, 0x001b),
	A6XX_PROTECT_NORDWR(0x00775, 0x000a),
	A6XX_PROTECT_RDONLY(0x00789, 0x0000),
	A6XX_PROTECT_RDONLY(0x0078c, 0x0013),
	A6XX_PROTECT_NORDWR(0x00800, 0x0029),
	A6XX_PROTECT_NORDWR(0x00837, 0x00af),
	A6XX_PROTECT_RDONLY(0x008e7, 0x00c9),
	A6XX_PROTECT_NORDWR(0x008ec, 0x00c3),
	A6XX_PROTECT_NORDWR(0x009b1, 0x0250),
	A6XX_PROTECT_NORDWR(0x00c07, 0x0008),
	A6XX_PROTECT_RDONLY(0x00ce0, 0x0001),
	A6XX_PROTECT_RDONLY(0x00df0, 0x0000),
	A6XX_PROTECT_NORDWR(0x00df1, 0x0000),
	A6XX_PROTECT_NORDWR(0x00e01, 0x0000),
	A6XX_PROTECT_NORDWR(0x00e03, 0x1fff),
	A6XX_PROTECT_NORDWR(0x03c00, 0x00c5),
	A6XX_PROTECT_RDONLY(0x03cc6, 0x0039),
	A6XX_PROTECT_NORDWR(0x03d00, 0x1fff),
	A6XX_PROTECT_NORDWR(0x08600, 0x01ff),
	A6XX_PROTECT_NORDWR(0x08e00, 0x00ff),
	A6XX_PROTECT_RDONLY(0x08f00, 0x0000),
	A6XX_PROTECT_NORDWR(0x08f01, 0x01be),
	A6XX_PROTECT_NORDWR(0x09600, 0x01ff),
	A6XX_PROTECT_RDONLY(0x0981a, 0x02e5),
	A6XX_PROTECT_NORDWR(0x09e00, 0x01ff),
	A6XX_PROTECT_NORDWR(0x0a600, 0x01ff),
	A6XX_PROTECT_NORDWR(0x0a82e, 0x0000),
	A6XX_PROTECT_NORDWR(0x0ae00, 0x0000),
	A6XX_PROTECT_NORDWR(0x0ae02, 0x0004),
	A6XX_PROTECT_NORDWR(0x0ae08, 0x0006),
	A6XX_PROTECT_NORDWR(0x0ae10, 0x00bf),
	A6XX_PROTECT_RDONLY(0x0aed0, 0x002f),
	A6XX_PROTECT_NORDWR(0x0af00, 0x027f),
	A6XX_PROTECT_NORDWR(0x0b600, 0x1fff),
	A6XX_PROTECT_NORDWR(0x0dc00, 0x1fff),
	A6XX_PROTECT_RDONLY(0x0fc00, 0x1fff),
	A6XX_PROTECT_NORDWR(0x18400, 0x003f),
	A6XX_PROTECT_RDONLY(0x18440, 0x013f),
	A6XX_PROTECT_NORDWR(0x18580, 0x1fff),
	A6XX_PROTECT_NORDWR(0x1b400, 0x1fff),
	A6XX_PROTECT_NORDWR(0x1f400, 0x0477),
	A6XX_PROTECT_RDONLY(0x1f878, 0x0507),
	A6XX_PROTECT_NORDWR(0x1f930, 0x0329),
	A6XX_PROTECT_NORDWR(0x1fd80, 0x1fff),
	A6XX_PROTECT_NORDWR(0x27800, 0x007f),
	A6XX_PROTECT_RDONLY(0x27880, 0x0385),
	A6XX_PROTECT_NORDWR(0x27882, 0x0009),
	A6XX_PROTECT_NORDWR(0x27c06, 0x0000),
};
DECLARE_ADRENO_PROTECT(a840_protect, 15);

static const struct adreno_reglist a840_gbif[] = {
	{ REG_A6XX_GBIF_QSB_SIDE0, 0x00071e20 },
	{ REG_A6XX_GBIF_QSB_SIDE1, 0x00071e20 },
	{ REG_A6XX_GBIF_QSB_SIDE2, 0x00071e20 },
	{ REG_A6XX_GBIF_QSB_SIDE3, 0x00071e20 },
	{ REG_A8XX_GBIF_CX_CONFIG, 0x20023000 },
	{ },
};

static const struct adreno_info a8xx_gpus[] = {
	{
		.chip_ids = ADRENO_CHIP_IDS(0x44070001),
		.family = ADRENO_8XX_GEN2,
		.fw = {
			[ADRENO_FW_SQE] = "/*(DEBLOBBED)*/",
			[ADRENO_FW_GMU] = "/*(DEBLOBBED)*/",
		},
		.gmem = 21 * SZ_1M,
		.inactive_period = DRM_MSM_INACTIVE_PERIOD,
		.quirks = ADRENO_QUIRK_HAS_CACHED_COHERENT |
			  ADRENO_QUIRK_HAS_HW_APRIV,
		.funcs = &a8xx_gpu_funcs,
		.a6xx = &(const struct a6xx_info) {
			.protect = &x285_protect,
			.nonctxt_reglist = x285_nonctxt_regs,
			.gbif_cx = a840_gbif,
			.max_slices = 4,
			.gmu_chipid = 0x8010100,
			.bcms = (const struct a6xx_bcm[]) {
				{ .name = "SH0", .buswidth = 16 },
				{ .name = "MC0", .buswidth = 4 },
				{
					.name = "ACV",
					.fixed = true,
					.perfmode = BIT(2),
					.perfmode_bw = 16500000,
				},
				{ /* sentinel */ },
			},
		},
	}, {
		.chip_ids = ADRENO_CHIP_IDS(0x44050a01),
		.family = ADRENO_8XX_GEN2,
		.fw = {
			[ADRENO_FW_SQE] = "/*(DEBLOBBED)*/",
			[ADRENO_FW_GMU] = "/*(DEBLOBBED)*/",
			[ADRENO_FW_AQE] = "/*(DEBLOBBED)*/",
		},
		.gmem = 18 * SZ_1M,
		.inactive_period = DRM_MSM_INACTIVE_PERIOD,
		.quirks = ADRENO_QUIRK_HAS_CACHED_COHERENT |
			  ADRENO_QUIRK_HAS_HW_APRIV,
		.funcs = &a8xx_gpu_funcs,
		.a6xx = &(const struct a6xx_info) {
			.protect = &a840_protect,
			.nonctxt_reglist = a840_nonctxt_regs,
			.gbif_cx = a840_gbif,
			.max_slices = 3,
			.gmu_chipid = 0x8020100,
			.bcms = (const struct a6xx_bcm[]) {
				{ .name = "SH0", .buswidth = 16 },
				{ .name = "MC0", .buswidth = 4 },
				{
					.name = "ACV",
					.fixed = true,
					.perfmode = BIT(2),
					.perfmode_bw = 10687500,
				},
				{ /* sentinel */ },
			},
		},
		.preempt_record_size = 19708 * SZ_1K,
	}
};

DECLARE_ADRENO_GPULIST(a8xx);

static inline __always_unused void __build_asserts(void)
{
	BUILD_BUG_ON(a630_protect.count > a630_protect.count_max);
	BUILD_BUG_ON(a650_protect.count > a650_protect.count_max);
	BUILD_BUG_ON(a660_protect.count > a660_protect.count_max);
	BUILD_BUG_ON(a690_protect.count > a690_protect.count_max);
	BUILD_BUG_ON(a730_protect.count > a730_protect.count_max);
	BUILD_BUG_ON(a840_protect.count > a840_protect.count_max);
}
