/* SPDX-License-Identifier: GPL-2.0-or-later
 * sma1307.h -- sma1307 ALSA SoC Audio driver
 *
 * Copyright 2024 Iron Device Corporation
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 */

#ifndef _SMA1307_H
#define _SMA1307_H

#include <sound/soc.h>

enum sma1307_fault {
	SMA1307_FAULT_OT1,
	SMA1307_FAULT_OT2,
	SMA1307_FAULT_UVLO,
	SMA1307_FAULT_OVP_BST,
	SMA1307_FAULT_OCP_SPK,
	SMA1307_FAULT_OCP_BST,
	SMA1307_FAULT_CLK
};

enum sma1307_mode {
	SMA1307_MONO_MODE,
	SMA1307_LEFT_MODE,
	SMA1307_RIGHT_MODE,
};

enum sma1307_sdo_mode {
	SMA1307_OUT_DATA_ONE_48K,
	SMA1307_OUT_DATA_TWO_48K,
	SMA1307_OUT_DATA_TWO_24K,
	SMA1307_OUT_CLK_PLL,
	SMA1307_OUT_CLK_OSC
};

enum sma1307_sdo_source {
	SMA1307_OUT_DISABLE,
	SMA1307_OUT_FORMAT_C,
	SMA1307_OUT_MIXER_OUT,
	SMA1307_OUT_AFTER_DSP,
	SMA1307_OUT_VRMS2_AVG,
	SMA1307_OUT_BATTERY,
	SMA1307_OUT_TEMP,
	SMA1307_OUT_AFTER_DELAY
};

struct sma1307_setting_file {
	bool status;
	char *header;
	int *def;
	int *mode_set[5];
	int checksum;
	int num_mode;
	size_t header_size;
	size_t def_size;
	size_t mode_size;
};

#define SMA1307_I2C_ADDR_00		0x1e
#define SMA1307_I2C_ADDR_01		0x3e
#define SMA1307_I2C_ADDR_10		0x5e
#define SMA1307_I2C_ADDR_11		0x7e

#define DEVICE_NAME_SMA1307A		"sma1307a"
#define DEVICE_NAME_SMA1307AQ		"sma1307aq"

#define SMA1307_EXTERNAL_CLOCK_19_2		0x00
#define SMA1307_EXTERNAL_CLOCK_24_576		0x01
#define SMA1307_PLL_CLKIN_MCLK			0x02
#define SMA1307_PLL_CLKIN_BCLK			0x03

#define SMA1307_OFFSET_DEFAULT_MODE		0x00
#define SMA1307_OFFSET_BURNING_MODE		0x01

#define SMA1307_SETTING_HEADER_SIZE		0x08
#define SMA1307_SETTING_DEFAULT_SIZE		0xC0

#define SMA1307_DEFAULT_SET			0x00
#define SMA1307_BINARY_FILE_SET			0x01

/* Controls Name */
#define SMA1307_REG_CTRL_NAME		"Register Byte Control"
#define SMA1307_VOL_CTRL_NAME		"Speaker Volume"
#define SMA1307_FORCE_MUTE_CTRL_NAME	"Force Mute Switch"
#define SMA1307_TDM_RX0_POS_NAME	"TDM RX Slot0 Position"
#define SMA1307_TDM_RX1_POS_NAME	"TDM RX Slot1 Position"
#define SMA1307_TDM_TX0_POS_NAME	"TDM TX Slot0 Position"
#define SMA1307_TDM_TX1_POS_NAME	"TDM TX Slot1 Position"
#define SMA1307_OT1_SW_PROT_CTRL_NAME	"OT1 SW Protection Switch"
#define SMA1307_RESET_CTRL_NAME		"Reset Switch"
#define SMA1307_CHECK_FAULT_STATUS_NAME	"Check Fault Status"
#define SMA1307_CHECK_FAULT_PERIOD_NAME	"Check Fault Period"

/* DAPM Name */
#define SMA1307_AIF_IN_NAME		"AIF IN Source"
#define SMA1307_AIF_OUT0_NAME		"AIF OUT0 Source"
#define SMA1307_AIF_OUT1_NAME		"AIF OUT1 Source"

/*
 * SMA1307 Register Definition
 */

/* SMA1307 Register Addresses */
#define SMA1307_00_SYSTEM_CTRL			0x00
#define SMA1307_01_INPUT_CTRL1			0x01
#define SMA1307_02_BROWN_OUT_PROT1		0x02
#define SMA1307_03_BROWN_OUT_PROT2		0x03
#define SMA1307_04_BROWN_OUT_PROT3		0x04
#define SMA1307_05_BROWN_OUT_PROT8		0x05
#define SMA1307_06_BROWN_OUT_PROT9		0x06
#define SMA1307_07_BROWN_OUT_PROT10		0x07
#define SMA1307_08_BROWN_OUT_PROT11		0x08
#define SMA1307_09_OUTPUT_CTRL			0x09
#define SMA1307_0A_SPK_VOL			0x0A
#define SMA1307_0B_BST_TEST			0x0B
#define SMA1307_0C_BOOST_CTRL8			0x0C
#define SMA1307_0D_SPK_TEST			0x0D
#define SMA1307_0E_MUTE_VOL_CTRL		0x0E
#define SMA1307_0F_VBAT_TEMP_SENSING		0x0F

#define SMA1307_10_SYSTEM_CTRL1			0x10
#define SMA1307_11_SYSTEM_CTRL2			0x11
#define SMA1307_12_SYSTEM_CTRL3			0x12
#define SMA1307_13_DELAY			0x13
#define SMA1307_14_MODULATOR			0x14
#define SMA1307_15_BASS_SPK1			0x15
#define SMA1307_16_BASS_SPK2			0x16
#define SMA1307_17_BASS_SPK3			0x17
#define SMA1307_18_BASS_SPK4			0x18
#define SMA1307_19_BASS_SPK5			0x19
#define SMA1307_1A_BASS_SPK6			0x1A
#define SMA1307_1B_BASS_SPK7			0x1B
#define SMA1307_1C_BROWN_OUT_PROT20		0x1C
#define SMA1307_1D_BROWN_OUT_PROT0		0x1D
#define SMA1307_1E_TONE_GENERATOR		0x1E
#define SMA1307_1F_TONE_FINE_VOLUME		0x1F

#define SMA1307_22_COMP_HYS_SEL			0x22
#define SMA1307_23_COMPLIM1			0x23
#define SMA1307_24_COMPLIM2			0x24
#define SMA1307_25_COMPLIM3			0x25
#define SMA1307_26_COMPLIM4			0x26
#define SMA1307_27_BROWN_OUT_PROT4		0x27
#define SMA1307_28_BROWN_OUT_PROT5		0x28
#define SMA1307_29_BROWN_OUT_PROT12		0x29
#define SMA1307_2A_BROWN_OUT_PROT13		0x2A
#define SMA1307_2B_BROWN_OUT_PROT14		0x2B
#define SMA1307_2C_BROWN_OUT_PROT15		0x2C
#define SMA1307_2D_BROWN_OUT_PROT6		0x2D
#define SMA1307_2E_BROWN_OUT_PROT7		0x2E
#define SMA1307_2F_BROWN_OUT_PROT16		0x2F

#define SMA1307_30_BROWN_OUT_PROT17		0x30
#define SMA1307_31_BROWN_OUT_PROT18		0x31
#define SMA1307_32_BROWN_OUT_PROT19		0x32
#define SMA1307_34_OCP_SPK			0x34
#define SMA1307_35_FDPEC_CTRL0			0x35
#define SMA1307_36_PROTECTION			0x36
#define SMA1307_37_SLOPECTRL			0x37
#define SMA1307_38_POWER_METER			0x38
#define SMA1307_39_PMT_NZ_VAL			0x39
#define SMA1307_3B_TEST1			0x3B
#define SMA1307_3C_TEST2			0x3C
#define SMA1307_3D_TEST3			0x3D
#define SMA1307_3E_IDLE_MODE_CTRL		0x3E
#define SMA1307_3F_ATEST2			0x3F
#define SMA1307_8B_PLL_POST_N			0x8B
#define SMA1307_8C_PLL_N			0x8C
#define SMA1307_8D_PLL_A_SETTING		0x8D
#define SMA1307_8E_PLL_P_CP			0x8E
#define SMA1307_8F_ANALOG_TEST			0x8F

#define SMA1307_90_CRESTLIM1			0x90
#define SMA1307_91_CRESTLIM2			0x91
#define SMA1307_92_FDPEC_CTRL1			0x92
#define SMA1307_93_INT_CTRL			0x93
#define SMA1307_94_BOOST_CTRL9			0x94
#define SMA1307_95_BOOST_CTRL10			0x95
#define SMA1307_96_BOOST_CTRL11			0x96
#define SMA1307_97_OTP_TRM0			0x97
#define SMA1307_98_OTP_TRM1			0x98
#define SMA1307_99_OTP_TRM2			0x99
#define SMA1307_9A_OTP_TRM3			0x9A

#define SMA1307_A0_PAD_CTRL0			0xA0
#define	SMA1307_A1_PAD_CTRL1			0xA1
#define SMA1307_A2_TOP_MAN1			0xA2
#define SMA1307_A3_TOP_MAN2			0xA3
#define SMA1307_A4_TOP_MAN3			0xA4
#define SMA1307_A5_TDM1				0xA5
#define SMA1307_A6_TDM2				0xA6
#define SMA1307_A7_CLK_MON			0xA7
#define SMA1307_A8_BOOST_CTRL1			0xA8
#define SMA1307_A9_BOOST_CTRL2			0xA9
#define SMA1307_AA_BOOST_CTRL3			0xAA
#define SMA1307_AB_BOOST_CTRL4			0xAB
#define SMA1307_AC_BOOST_CTRL5			0xAC
#define SMA1307_AD_BOOST_CTRL6			0xAD
#define SMA1307_AE_BOOST_CTRL7			0xAE
#define SMA1307_AF_LPF				0xAF

#define SMA1307_B0_RMS_TC1			0xB0
#define SMA1307_B1_RMS_TC2			0xB1
#define SMA1307_B2_AVG_TC1			0xB2
#define SMA1307_B3_AVG_TC2			0xB3
#define SMA1307_B4_PRVALUE1			0xB4
#define SMA1307_B5_PRVALUE2			0xB5
#define SMA1307_B8_SPK_NG_CTRL1			0xB8
#define SMA1307_B9_SPK_NG_CTRL2			0xB9
#define SMA1307_BA_DGC1				0xBA
#define SMA1307_BB_DGC2				0xBB
#define SMA1307_BC_DGC3				0xBC
#define SMA1307_BD_MCBS_CTRL1			0xBD
#define SMA1307_BE_MCBS_CTRL2			0xBE

/* Status Register Read Only */
#define SMA1307_F5_READY_FOR_V_SAR		0xF5
#define SMA1307_F7_READY_FOR_T_SAR		0xF7
#define SMA1307_F8_STATUS_T1			0xF8
#define SMA1307_F9_STATUS_T2			0xF9
#define SMA1307_FA_STATUS1			0xFA
#define SMA1307_FB_STATUS2			0xFB
#define SMA1307_FC_STATUS3			0xFC
#define SMA1307_FD_STATUS4			0xFD
#define SMA1307_FE_STATUS5			0xFE
#define SMA1307_FF_DEVICE_INDEX			0xFF

/* SMA1307 Registers Bit Fields */
/* Power On/Off */
#define SMA1307_POWER_MASK			BIT(0)
#define SMA1307_POWER_OFF			0
#define SMA1307_POWER_ON			BIT(0)

/* Reset */
#define SMA1307_RESET_MASK			BIT(1)
#define SMA1307_RESET_ON			BIT(1)

/* Left Polarity */
#define SMA1307_LEFTPOL_MASK			BIT(3)
#define SMA1307_LOW_FIRST_CH			0
#define SMA1307_HIGH_FIRST_CH			BIT(3)

/* SCK Falling/Rising */
#define SMA1307_SCK_RISING_MASK			BIT(2)
#define SMA1307_SCK_FALLING_EDGE		0
#define SMA1307_SCK_RISING_EDGE			BIT(2)

/* SPK Mute */
#define SMA1307_SPK_MUTE_MASK			BIT(0)
#define SMA1307_SPK_UNMUTE			0
#define SMA1307_SPK_MUTE			BIT(0)

/* SPK Mode */
#define SMA1307_SPK_MODE_MASK			(BIT(2)|BIT(3)|BIT(4))
#define SMA1307_SPK_OFF				0
#define SMA1307_SPK_MONO			BIT(2)
#define SMA1307_SPK_STEREO			BIT(4)

/* Mono Mix */
#define SMA1307_MONOMIX_MASK BIT(0)
#define SMA1307_MONOMIX_OFF 0
#define SMA1307_MONOMIX_ON BIT(0)

/* LR Data Swap */
#define SMA1307_LR_DATA_SW_MASK	BIT(4)
#define SMA1307_LR_DATA_SW_NORMAL 0
#define SMA1307_LR_DATA_SW_SWAP BIT(4)

/* PLL On/Off */
#define SMA1307_PLL_MASK			BIT(6)
#define SMA1307_PLL_ON				0
#define SMA1307_PLL_OFF				BIT(6)

/* Input Format */
#define SMA1307_I2S_MODE_MASK		(BIT(4)|BIT(5)|BIT(6))
#define SMA1307_STANDARD_I2S		0
#define SMA1307_LJ			BIT(4)
#define SMA1307_RJ_16BIT		BIT(6)
#define SMA1307_RJ_18BIT		(BIT(4)|BIT(6))
#define SMA1307_RJ_20BIT		(BIT(5)|BIT(6))
#define SMA1307_RJ_24BIT		(BIT(4)|BIT(5)|BIT(6))

/* Controller / Device Setting */
#define SMA1307_CONTROLLER_DEVICE_MASK	BIT(7)
#define SMA1307_DEVICE_MODE		0
#define SMA1307_CONTROLLER_MODE		BIT(7)

/* Port Config */
#define SMA1307_PORT_CONFIG_MASK	(BIT(6)|BIT(7))
#define SMA1307_INPUT_PORT_ONLY		0
#define SMA1307_OUTPUT_PORT_ENABLE	BIT(7)

/* SDO Output */
#define SMA1307_SDO_OUTPUT_MASK		BIT(3)
#define SMA1307_LOGIC_OUTPUT		0
#define SMA1307_HIGH_Z_OUTPUT		BIT(3)

#define SMA1307_DATA_CLK_SEL_MASK	(BIT(6)|BIT(7))
#define SMA1307_SDO_DATA		0
#define SMA1307_SDO_CLK_PLL		BIT(6)
#define SMA1307_SDO_CLK_OSC		(BIT(6)|BIT(7))

/* SDO Output2 */
#define SMA1307_SDO_OUTPUT2_MASK	BIT(0)
#define SMA1307_ONE_SDO_PER_CH		0
#define SMA1307_TWO_SDO_PER_CH		BIT(0)

/* SDO Output3 */
#define SMA1307_SDO_OUTPUT3_MASK	BIT(2)
#define SMA1307_SDO_OUTPUT3_DIS		0
#define SMA1307_TWO_SDO_PER_CH_24K	BIT(2)

/* SDO OUT1 Select*/
#define SMA1307_SDO_OUT1_SEL_MASK	(BIT(3)|BIT(4)|BIT(5))
#define SMA1307_SDO1_DISABLE		0
#define SMA1307_SDO1_FORMAT_C		BIT(3)
#define SMA1307_SDO1_MONO_MIX		BIT(4)
#define SMA1307_SDO1_AFTER_DSP		(BIT(3)|BIT(4))
#define SMA1307_SDO1_VRMS2_AVG		BIT(5)
#define SMA1307_SDO1_VBAT_MON		(BIT(3)|BIT(5))
#define SMA1307_SDO1_TEMP_MON		(BIT(4)|BIT(5))
#define SMA1307_SDO1_AFTER_DELAY	(BIT(3)|BIT(4)|BIT(5))

/* SDO OUT0 Select*/
#define SMA1307_SDO_OUT0_SEL_MASK	(BIT(0)|BIT(1)|BIT(2))
#define SMA1307_SDO0_DISABLE		0
#define SMA1307_SDO0_FORMAT_C		BIT(0)
#define SMA1307_SDO0_MONO_MIX		BIT(1)
#define SMA1307_SDO0_AFTER_DSP		(BIT(0)|BIT(1))
#define SMA1307_SDO0_VRMS2_AVG		BIT(2)
#define SMA1307_SDO0_VBAT_MON		(BIT(0)|BIT(2))
#define SMA1307_SDO0_TEMP_MON		(BIT(1)|BIT(2))
#define SMA1307_SDO0_AFTER_DELAY	(BIT(0)|BIT(1)|BIT(2))

/* INTERRUPT Operation */
#define SMA1307_SEL_INT_MASK		BIT(2)
#define SMA1307_INT_CLEAR_AUTO		0
#define SMA1307_INT_CLEAR_MANUAL	BIT(2)

/* INTERRUPT CLEAR */
#define SMA1307_CLR_INT_MASK		BIT(1)
#define SMA1307_INT_READY		0
#define SMA1307_INT_CLEAR		BIT(1)

/* INTERRUPT Disable */
#define SMA1307_DIS_INT_MASK		BIT(0)
#define SMA1307_NORMAL_INT		0
#define SMA1307_HIGH_Z_INT		BIT(0)

/* Interface Control */
#define SMA1307_INTERFACE_MASK		(BIT(5)|BIT(6)|BIT(7))
#define SMA1307_LJ_FORMAT		BIT(5)
#define SMA1307_I2S_FORMAT		(BIT(5)|BIT(6))
#define SMA1307_TDM_FORMAT		BIT(7)

#define SMA1307_SCK_RATE_MASK		(BIT(3)|BIT(4))
#define SMA1307_SCK_64FS		0
#define SMA1307_SCK_32FS		BIT(4)

#define SMA1307_DATA_WIDTH_MASK		(BIT(1)|BIT(2))
#define SMA1307_DATA_24BIT		0
#define SMA1307_DATA_16BIT		(BIT(1)|BIT(2))

#define SMA1307_TDM_TX_MODE_MASK	BIT(6)
#define SMA1307_TDM_TX_MONO		0
#define SMA1307_TDM_TX_STEREO		BIT(6)

#define SMA1307_TDM_SLOT0_RX_POS_MASK (BIT(3)|BIT(4)|BIT(5))
#define SMA1307_TDM_SLOT0_RX_POS_0 0
#define SMA1307_TDM_SLOT0_RX_POS_1 BIT(3)
#define SMA1307_TDM_SLOT0_RX_POS_2 BIT(4)
#define SMA1307_TDM_SLOT0_RX_POS_3 (BIT(3)|BIT(4))
#define SMA1307_TDM_SLOT0_RX_POS_4 BIT(5)
#define SMA1307_TDM_SLOT0_RX_POS_5 (BIT(3)|BIT(5))
#define SMA1307_TDM_SLOT0_RX_POS_6 (BIT(4)|BIT(5))
#define SMA1307_TDM_SLOT0_RX_POS_7 (BIT(3)|BIT(4)|BIT(5))

#define SMA1307_TDM_SLOT1_RX_POS_MASK (BIT(0)|BIT(1)|BIT(2))
#define SMA1307_TDM_SLOT1_RX_POS_0 0
#define SMA1307_TDM_SLOT1_RX_POS_1 BIT(0)
#define SMA1307_TDM_SLOT1_RX_POS_2 BIT(1)
#define SMA1307_TDM_SLOT1_RX_POS_3 (BIT(0)|BIT(1))
#define SMA1307_TDM_SLOT1_RX_POS_4 BIT(2)
#define SMA1307_TDM_SLOT1_RX_POS_5 (BIT(0)|BIT(2))
#define SMA1307_TDM_SLOT1_RX_POS_6 (BIT(1)|BIT(2))
#define SMA1307_TDM_SLOT1_RX_POS_7 (BIT(0)|BIT(1)|BIT(2))

/* TDM2 FORMAT : 0xA6 */
#define SMA1307_TDM_DL_MASK	BIT(7)
#define SMA1307_TDM_DL_16	0
#define SMA1307_TDM_DL_32	BIT(7)

#define SMA1307_TDM_N_SLOT_MASK	BIT(6)
#define SMA1307_TDM_N_SLOT_4	0
#define SMA1307_TDM_N_SLOT_8	BIT(6)

#define SMA1307_TDM_SLOT0_TX_POS_MASK	(BIT(3)|BIT(4)|BIT(5))
#define SMA1307_TDM_SLOT0_TX_POS_0	0
#define SMA1307_TDM_SLOT0_TX_POS_1	BIT(3)
#define SMA1307_TDM_SLOT0_TX_POS_2	BIT(4)
#define SMA1307_TDM_SLOT0_TX_POS_3	(BIT(3)|BIT(4))
#define SMA1307_TDM_SLOT0_TX_POS_4	BIT(5)
#define SMA1307_TDM_SLOT0_TX_POS_5	(BIT(3)|BIT(5))
#define SMA1307_TDM_SLOT0_TX_POS_6	(BIT(4)|BIT(5))
#define SMA1307_TDM_SLOT0_TX_POS_7	(BIT(3)|BIT(4)|BIT(5))

#define SMA1307_TDM_SLOT1_TX_POS_MASK	(BIT(0)|BIT(1)|BIT(2))
#define SMA1307_TDM_SLOT1_TX_POS_0	0
#define SMA1307_TDM_SLOT1_TX_POS_1	BIT(0)
#define SMA1307_TDM_SLOT1_TX_POS_2	BIT(1)
#define SMA1307_TDM_SLOT1_TX_POS_3	(BIT(0)|BIT(1))
#define SMA1307_TDM_SLOT1_TX_POS_4	BIT(2)
#define SMA1307_TDM_SLOT1_TX_POS_5	(BIT(0)|BIT(2))
#define SMA1307_TDM_SLOT1_TX_POS_6	(BIT(1)|BIT(2))
#define SMA1307_TDM_SLOT1_TX_POS_7	(BIT(0)|BIT(1)|BIT(2))

/* OTP STATUS */
#define SMA1307_OTP_STAT_MASK		BIT(6)
#define SMA1307_OTP_STAT_0		0
#define SMA1307_OTP_STAT_1		BIT(6)

/* STATUS */
#define SMA1307_OT1_OK_STATUS		BIT(7)
#define SMA1307_OT2_OK_STATUS		BIT(6)
#define SMA1307_UVLO_STATUS		BIT(5)
#define SMA1307_OVP_BST_STATUS		BIT(4)
#define SMA1307_POWER_FLAG		BIT(3)

#define SMA1307_SCAN_CHK		BIT(7)
#define SMA1307_OCP_SPK_STATUS		BIT(5)
#define SMA1307_OCP_BST_STATUS		BIT(4)
#define SMA1307_BOP_STATE		(BIT(1)|BIT(2)|BIT(3))
#define SMA1307_CLK_MON_STATUS		BIT(0)

#define SMA1307_DEVICE_ID		(BIT(3)|BIT(4))
#define SMA1307_REV_NUM_STATUS		(BIT(0)|BIT(1))
#define SMA1307_REV_NUM_REV0		0
#define SMA1307_REV_NUM_REV1		BIT(0)

#endif
